/* SPDX-License-Identifier: GPL-2.0-only */

#include <device/azalia_device.h>
#include <device/azalia_codec/realtek.h>

static const u32 realtek_alc887_vd_verbs[] = {
	AZALIA_SUBVENDOR(0, 0x1849588a),
	AZALIA_PIN_CFG(0, ALC887_SPDIF_OUT2, AZALIA_PIN_CFG_NC(0)),
	AZALIA_PIN_CFG(0, ALC887_DMIC_LR, AZALIA_PIN_CFG_NC(0)),
	AZALIA_PIN_CFG(0, ALC887_FRONT, AZALIA_PIN_DESC(
		AZALIA_JACK,
		AZALIA_EXTERNAL_PRIMARY_CHASSIS | AZALIA_REAR,
		AZALIA_LINE_OUT,
		AZALIA_STEREO_MONO_1_8,
		AZALIA_GREEN,
		AZALIA_JACK_PRESENCE_DETECT,
		2, 0
	)),
	AZALIA_PIN_CFG(0, ALC887_SURROUND, AZALIA_PIN_DESC(
		AZALIA_INTEGRATED,
		AZALIA_INTERNAL,
		AZALIA_SPEAKER,
		AZALIA_OTHER_ANALOG,
		AZALIA_COLOR_UNKNOWN,
		AZALIA_NO_JACK_PRESENCE_DETECT,
		1, 0
	)),
	AZALIA_PIN_CFG(0, ALC887_CENTER_LFE, AZALIA_PIN_CFG_NC(0)),
	AZALIA_PIN_CFG(0, ALC887_SIDE_SURROUND, AZALIA_PIN_CFG_NC(0)),
	AZALIA_PIN_CFG(0, ALC887_MIC1, AZALIA_PIN_DESC(
		AZALIA_JACK,
		AZALIA_EXTERNAL_PRIMARY_CHASSIS | AZALIA_REAR,
		AZALIA_MIC_IN,
		AZALIA_STEREO_MONO_1_8,
		AZALIA_PINK,
		AZALIA_JACK_PRESENCE_DETECT,
		5, 0
	)),
	AZALIA_PIN_CFG(0, ALC887_MIC2, AZALIA_PIN_DESC(
		AZALIA_JACK,
		AZALIA_EXTERNAL_PRIMARY_CHASSIS | AZALIA_FRONT,
		AZALIA_MIC_IN,
		AZALIA_STEREO_MONO_1_8,
		AZALIA_PINK,
		AZALIA_JACK_PRESENCE_DETECT,
		6, 0
	)),
	AZALIA_PIN_CFG(0, ALC887_LINE1, AZALIA_PIN_CFG_NC(0)),
	AZALIA_PIN_CFG(0, ALC887_LINE2, AZALIA_PIN_DESC(
		AZALIA_JACK,
		AZALIA_EXTERNAL_PRIMARY_CHASSIS | AZALIA_FRONT,
		AZALIA_HP_OUT,
		AZALIA_STEREO_MONO_1_8,
		AZALIA_GREEN,
		AZALIA_JACK_PRESENCE_DETECT,
		3, 0
	)),
	AZALIA_PIN_CFG(0, ALC887_CD, AZALIA_PIN_CFG_NC(0)),
	AZALIA_PIN_CFG(0, ALC887_PC_BEEP, 0x4024c601),
	AZALIA_PIN_CFG(0, ALC887_SPDIF_OUT1, AZALIA_PIN_DESC(
		AZALIA_JACK,
		AZALIA_EXTERNAL_PRIMARY_CHASSIS | AZALIA_REAR,
		AZALIA_SPDIF_OUT,
		AZALIA_OPTICAL,
		AZALIA_BLACK,
		AZALIA_NO_JACK_PRESENCE_DETECT,
		4, 0
	)),
	AZALIA_PIN_CFG(0, ALC887_SPDIF_IN, AZALIA_PIN_CFG_NC(0)),
};

static const u32 intel_display_audio_verbs[] = {
	AZALIA_SUBVENDOR(2, 0x80860101),
	AZALIA_PIN_CFG(2, 0x05, AZALIA_PIN_DESC(
		AZALIA_JACK,
		AZALIA_DIGITAL_DISPLAY,
		AZALIA_DIGITAL_OTHER_OUT,
		AZALIA_OTHER_DIGITAL,
		AZALIA_COLOR_UNKNOWN,
		AZALIA_JACK_PRESENCE_DETECT,
		1, 0
	)),
	AZALIA_PIN_CFG(2, 0x06, AZALIA_PIN_DESC(
		AZALIA_JACK,
		AZALIA_DIGITAL_DISPLAY,
		AZALIA_DIGITAL_OTHER_OUT,
		AZALIA_OTHER_DIGITAL,
		AZALIA_COLOR_UNKNOWN,
		AZALIA_JACK_PRESENCE_DETECT,
		2, 0
	)),
	AZALIA_PIN_CFG(2, 0x07, AZALIA_PIN_DESC(
		AZALIA_JACK,
		AZALIA_DIGITAL_DISPLAY,
		AZALIA_DIGITAL_OTHER_OUT,
		AZALIA_OTHER_DIGITAL,
		AZALIA_COLOR_UNKNOWN,
		AZALIA_JACK_PRESENCE_DETECT,
		3, 0
	)),
};

const u32 pc_beep_verbs[] = {
};

struct azalia_codec mainboard_azalia_codecs[] = {
	{
		.name         = "Realtek ALC887-VD",
		.vendor_id    = 0x10ec0887,
		.subsystem_id = 0x1849588a,
		.address      = 0,
		.verbs        = realtek_alc887_vd_verbs,
		.verb_count   = ARRAY_SIZE(realtek_alc887_vd_verbs),
	},
	{
		.name         = "Intel Display Audio (HDMI/DP)",
		.vendor_id    = 0x8086280b,
		.subsystem_id = 0x80860101,
		.address      = 2,
		.verbs        = intel_display_audio_verbs,
		.verb_count   = ARRAY_SIZE(intel_display_audio_verbs),
	},
	{ /* terminator */ }
};

AZALIA_ARRAY_SIZES;
