/* SPDX-License-Identifier: GPL-2.0-or-later */

#include <baseboard/gpio.h>
#include <baseboard/variants.h>
#include <boardid.h>
#include <soc/gpio.h>

/* Pad configuration in ramstage*/
static const struct pad_config gpio_table[] = {
	/* GPP_A00:     ESPI_IO0_EC_R */
	/*  GPP_A00 : GPP_A00 ==> ESPI_IO0_EC_R configured on reset, do not touch */

	/* GPP_A01:     ESPI_IO1_EC_R */
	/*  GPP_A01 : GPP_A01 ==> ESPI_IO1_EC_R configured on reset, do not touch */

	/* GPP_A02:     ESPI_IO2_EC_R */
	/*  GPP_A02 : GPP_A02 ==> ESPI_IO2_EC_R configured on reset, do not touch */

	/* GPP_A03:     ESPI_IO3_EC_R */
	/*  GPP_A03 : GPP_A03 ==> ESPI_IO3_EC_R configured on reset, do not touch */

	/* GPP_A04:     ESPI_CS0_EC_R_N */
	/*  GPP_A04 : GPP_A04 ==> ESPI_CS0_HDR_L configured on reset, do not touch */

	/* GPP_A05:     ESPI_CLK_EC_R */
	/*  GPP_A05 : GPP_A05 ==> ESPI_CLK_HDR configured on reset, do not touch */

	/* GPP_A06:     ESPI_RST_EC_R_N */
	/*  GPP_A06 : GPP_A06 ==> ESPI_RST_HDR configured on reset, do not touch */

	/* GPP_A08:     NC */
	PAD_NC(GPP_A08, NONE),
	/* GPP_A09:     NC */
	PAD_NC(GPP_A09, NONE),
	/* GPP_A10:     NC */
	PAD_NC(GPP_A10, NONE),
	/* GPP_A11:     TP */
	PAD_NC(GPP_A11, NONE),
	/* GPP_A12:     NC */
	PAD_NC(GPP_A12, NONE),
	/* GPP_A13:     MEM_STRAP_0 */
	PAD_CFG_GPI(GPP_A13, NONE, DEEP),
	/* GPP_A15:     SOC_GPP_A15 */
	PAD_CFG_GPI(GPP_A15, NONE, DEEP),
	/* GPP_A16:     BT_RF_KILL_N */
	PAD_CFG_GPO(GPP_A16, 1, DEEP),
	/* GPP_A17:     WIFI_RF_KILL_N */
	PAD_CFG_GPO(GPP_A17, 1, DEEP),

	/* GPP_B00:     USBC_SML_CLK_PD */
	PAD_CFG_NF(GPP_B00, NONE, DEEP, NF1),
	/* GPP_B01:     USBC_SML_DATA_PD */
	PAD_CFG_NF(GPP_B01, NONE, DEEP, NF1),
	/* GPP_B02:     NC */
	PAD_NC(GPP_B02, NONE),
	/* GPP_B03:     NC */
	PAD_NC(GPP_B03, NONE),

	/* GPP_B06:     NC */
	PAD_NC(GPP_B06, NONE),
	/* GPP_B07:     NC */
	PAD_NC(GPP_B07, NONE),
	/* GPP_B08:     NC */
	PAD_NC(GPP_B08, NONE),
	/* GPP_B09:     M2_GEN4_SSD_RESET_N */
	PAD_CFG_GPO(GPP_B09, 1, PLTRST),
	/* GPP_B10:     NC */
	PAD_NC(GPP_B10, NONE),
	/* GPP_B1:     NC */
	PAD_NC(GPP_B11, NONE),
	/* GPP_B12:     PM_SLP_S0_N */
	PAD_CFG_NF(GPP_B12, NONE, DEEP, NF1),
	/* GPP_B13:     PLT_RST_N */
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1),
	/* GPP_B14:     MOD_TCSS2_DISP_HPD4 */
	PAD_CFG_NF(GPP_B14, NONE, DEEP, NF2),
	/* GPP_B15:     NC */
	PAD_NC(GPP_B15, NONE),
	/* GPP_B16:     GEN5_SSD_PWREN */
	PAD_CFG_GPO(GPP_B16, 1, PLTRST),
	/* GPP_B17:     NC */
	PAD_NC(GPP_B17, NONE),
	/* GPP_B18:     ISH_I2C2_SDA_SNSR_HDR */
	/* NOTE: IOSSTAGE: 'Ignore' for S0ix */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPP_B18, NONE, DEEP, NF1),
	/* GPP_B19:     ISH_I2C2_SCL_SNSR_HDR */
	/* NOTE: IOSSTAGE: 'Ignore' for S0ix */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPP_B19, NONE, DEEP, NF1),
	/* GPP_B20:     NC */
	PAD_NC(GPP_B20, NONE),
	/* GPP_B21:     TCP_RETIMER_FORCE_PWR */
	PAD_CFG_GPO(GPP_B21, 0, DEEP),
	/* GPP_B22:     NC */
	PAD_NC(GPP_B22, NONE),
	/* GPP_B24:     MEM_STRAP_3 */
	PAD_CFG_GPI(GPP_B24, NONE, DEEP),
	/* GPP_B25:     MEM_STRAP_2 */
	PAD_CFG_GPI(GPP_B25, NONE, DEEP),

	/* GPP_C00:     NC */
	PAD_NC(GPP_C00, NONE),
	/* GPP_C01:     NC */
	PAD_NC(GPP_C01, NONE),
	/* GPP_C02:     GPP_C2_STRAP */
	PAD_CFG_GPI(GPP_C02, NONE, DEEP),
	/* GPP_C03:     NC */
	PAD_NC(GPP_C03, NONE),
	/* GPP_C04:     NC */
	PAD_NC(GPP_C04, NONE),
	PAD_CFG_GPO(GPP_C05, 1, DEEP),
	/* GPP_C06:     NC */
	PAD_NC(GPP_C06, NONE),

	/* GPP_C07:     MEM_CH_SEL */
	PAD_CFG_GPI(GPP_C07, NONE, DEEP),
	/* GPP_C08:     NC */
	PAD_NC(GPP_C08, NONE),
	/* GPP_C09:     NC */
	PAD_NC(GPP_C09, NONE),
	/* GPP_C10:     NC */
	PAD_NC(GPP_C10, NONE),
	/* GPP_C11:     NC */
	PAD_NC(GPP_C11, NONE),
	/* GPP_C12:     NC */
	PAD_NC(GPP_C12, NONE),
	/* GPP_C13:     NC */
	PAD_NC(GPP_C13, NONE),
	/* GPP_C14:     NC */
	PAD_NC(GPP_C14, NONE),
	/* GPP_C16:     TBT_LSX0_TXD  */
	PAD_CFG_NF(GPP_C16, NONE, DEEP, NF1),
	/* GPP_C17:     TBT_LSX0_RXD  */
	PAD_CFG_NF(GPP_C17, NONE, DEEP, NF1),
	/* GPP_C18:     NC */
	PAD_NC(GPP_C18, NONE),
	/* GPP_C19:     NC */
	PAD_NC(GPP_C19, NONE),
	/* GPP_C20:     MOD_TCSS1_LS_TX_DDC_SCL */
	PAD_CFG_NF(GPP_C20, NONE, DEEP, NF1),
	/* GPP_C21:     MOD_TCSS1_LS_RX_DDC_SDA */
	PAD_CFG_NF(GPP_C21, NONE, DEEP, NF1),
	/* GPP_C22:     MOD_TCSS2_LS_TX_DDC_SCL */
	PAD_CFG_NF(GPP_C22, NONE, DEEP, NF2),
	/* GPP_C23:     MOD_TCSS2_LS_RX_DDC_SDA */
	PAD_CFG_NF(GPP_C23, NONE, DEEP, NF2),
	/* GPP_D00:     TP */
	PAD_NC(GPP_D00, NONE),
	/* GPP_D01:     EN_SPK_PA */
	PAD_CFG_GPO(GPP_D01, 1, DEEP),
	/* GPP_D02:     SOC_WP_OD */
	PAD_CFG_GPI(GPP_D02, NONE, DEEP),
	/* GPP_D03:     NC */
	PAD_NC(GPP_D03, NONE),
	/* GPP_D04:     TP */
	PAD_NC(GPP_D04, NONE),
	/* GPP_D07:     NC */
	PAD_NC(GPP_D07, NONE),
	/* GPP_D08:     NC */
	PAD_NC(GPP_D08, NONE),
	/* GPP_D09:     I2S_MCLK1_OUT */
	PAD_CFG_NF(GPP_D09, NONE, DEEP, NF2),
	/* GPP_D10:     HDA_BCLK */
	PAD_CFG_NF(GPP_D10, NONE, DEEP, NF2),
	/* GPP_D11:     HDA_SYNC */
	PAD_CFG_NF(GPP_D11, NONE, DEEP, NF2),
	/* GPP_D12:     HDA_SDO */
	PAD_CFG_NF(GPP_D12, NONE, DEEP, NF2),
	/* GPP_D13:     HDA_SDI0 */
	PAD_CFG_NF(GPP_D13, NONE, DEEP, NF2),
	/* GPP_D14:     NC */
	PAD_NC(GPP_D14, NONE),
	/* GPP_D15:     NC */
	PAD_NC(GPP_D15, NONE),
	/* GPP_D16:	TP*/
	PAD_NC(GPP_D16, NONE),
	/* GPP_D17:	TP*/
	PAD_NC(GPP_D17, NONE),
	/* GPP_D18:     CLKREQ6_X4_GEN4_M2_SSD_N */
	PAD_CFG_NF(GPP_D18, NONE, DEEP, NF1),
	/* GPP_D19:     NC */
	PAD_NC(GPP_D19, NONE),
	/* GPP_D20:     CSE_EARLY_SW */
	PAD_CFG_GPI_SCI_HIGH(GPP_D20, NONE, DEEP, LEVEL),
	/* GPP_D21:     NC */
	PAD_NC(GPP_D21, NONE),
	/* GPP_D22:     NC */
	PAD_NC(GPP_D22, NONE),
	/* GPP_D23:     NC */
	PAD_NC(GPP_D23, NONE),
	/* GPP_D24:     MEM_STRAP_1 */
	PAD_CFG_GPI(GPP_D24, NONE, DEEP),
	/* GPP_D25:     NC */
	PAD_NC(GPP_D25, NONE),

	/* GPP_E01:     NC */
	PAD_NC(GPP_E01, NONE),
	/* GPP_E02:     GSC_SOC_INT_ODL */
	PAD_CFG_GPI_APIC_LOCK(GPP_E02, NONE, LEVEL, INVERT, LOCK_CONFIG),
	/* GPP_E03:     NC */
	PAD_NC(GPP_E03, NONE),
	/* GPP_E05:     TCHSCR_RPT_EN */
	PAD_CFG_GPO(GPP_E05, 0, PLTRST),
	/* GPP_E06:     SECURE_CAM_SW */
	PAD_CFG_GPI_TRIG_OWN(GPP_E06, NONE, PLTRST, LEVEL, ACPI),
	/* GPP_E07 : [] ==> EC_SOC_INT_ODL */
	PAD_CFG_GPI_APIC_LOCK(GPP_E07, NONE, LEVEL, INVERT, LOCK_CONFIG),
	/* GPP_E08:     NC */
	PAD_NC(GPP_E08, NONE),
	/* GPP_E10:     TP */
	PAD_NC(GPP_E10, NONE),
	/* GPP_E11:     NC */
	PAD_NC(GPP_E11, NONE),
	/* GPP_E12:     THC0_SPI1_IO_0_I2C4_SCL_TCH_PAD1*/
	PAD_CFG_NF(GPP_E12, NONE, DEEP, NF8),
	/* GPP_E13:     THC0_SPI1_IO_1_I2C4_SDA_TCH_PAD1 */
	PAD_CFG_NF(GPP_E13, NONE, DEEP, NF8),
	/* GPP_E14:     NC */
	PAD_NC(GPP_E14, NONE),
	/* GPP_E15:     NC */
	PAD_NC(GPP_E15, NONE),
	/* GPP_E16:     NC */
	PAD_NC(GPP_E16, NONE),
	/* GPP_E17:     NC */
	PAD_NC(GPP_E17, NONE),
	/* GPP_E18:     TCHPAD_INT# */
	PAD_CFG_GPI_APIC(GPP_E18, NONE, PLTRST, LEVEL, INVERT),
	/* GPP_E19:     FPMCU_PWREN */
	PAD_CFG_GPO(GPP_E19, 1, DEEP),
	/* GPP_E20:     NC */
	PAD_NC(GPP_E20, NONE),
	/* GPP_E21:     I2C_PMC_PD_INT_N */
	PAD_CFG_NF(GPP_E21, NONE, DEEP, NF1),
	/* GPP_E22:     NC */
	PAD_NC(GPP_E22, NONE),

	/* GPP_F00:     M.2_CNV_BRI_DT_BT_UART2_RTS_N */
	/* NOTE: IOSSTAGE: 'Ignore' for S0ix */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPP_F00, NONE, DEEP, NF1),
	/* GPP_F01:     M.2_CNV_BRI_RSP_BT_UART2_RXD */
	/* NOTE: IOSSTAGE: 'Ignore' for S0ix */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPP_F01, NONE, DEEP, NF1),
	/* GPP_F02:     M.2_CNV_RGI_DT_BT_UART2_TXD */
	/* NOTE: IOSSTAGE: 'Ignore' for S0ix */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPP_F02, NONE, DEEP, NF1),
	/* GPP_F03:     M.2_CNV_RGI_RSP_BT_UART2_CTS_N */
	/* NOTE: IOSSTAGE: 'Ignore' for S0ix */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPP_F03, NONE, DEEP, NF1),
	/* GPP_F04:     CNV_RF_RESET_R_N */
	/* NOTE: IOSSTAGE: 'Ignore' for S0ix */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPP_F04, NONE, DEEP, NF1),
	/* GPP_F05:     CRF_CLKREQ_R */
	/* NOTE: IOSSTAGE: 'Ignore' for S0ix */
	PAD_CFG_NF_IOSTANDBY_IGNORE(GPP_F05, NONE, DEEP, NF3),
	/* GPP_F06:     NC */
	PAD_NC(GPP_F06, NONE),
	/* GPP_F07:     NC */
	PAD_NC(GPP_F07, NONE),
	/* GPP_F08:     EN_TCHSCR_PWR */
	PAD_CFG_GPO(GPP_F08, 1, PLTRST),
	/* GPP_F09:     NC */
	PAD_NC(GPP_F09, NONE),
	/* GPP_F10:     ISH_GP_6_SNSR_HDR */
	PAD_CFG_NF(GPP_F10, NONE, DEEP, NF8),
	/* GPP_F11:     NC */
	PAD_NC(GPP_F11, NONE),
	/* GPP_F12:     TCHSCR_I2C5_SCL */
	PAD_CFG_NF(GPP_F12, NONE, DEEP, NF8),
	/* GPP_F13:     TCHSCR_I2C5_SDA */
	PAD_CFG_NF(GPP_F13, NONE, DEEP, NF8),
	/* GPP_F14:     NC */
	PAD_NC(GPP_F14, NONE),
	/* GPP_F15:     NC */
	PAD_NC(GPP_F15, NONE),
	/* GPP_F16:     TCHSCR_RST_L */
	PAD_CFG_GPO(GPP_F16, 1, DEEP),
	/* GPP_F17:     NC */
	PAD_NC(GPP_F17, NONE),
	/* GPP_F18:     TCHSCR_INT_L */
	PAD_CFG_GPI_APIC(GPP_F18, NONE, PLTRST, LEVEL, NONE),
	/* GPP_F19:     EN_UCAM_SENR_PWR */
	PAD_CFG_GPO(GPP_F19, 0, PLTRST),
	/* GPP_F20:     NC */
	PAD_NC(GPP_F20, NONE),
	/* GPP_F22:     NC */
	PAD_NC(GPP_F22, NONE),
	/* GPP_F23:     NC */
	PAD_NC(GPP_F23, NONE),

	/* GPP_H00:     GPP_H0_STRAP */
	PAD_CFG_GPO(GPP_H00, 1, PLTRST),
	/* GPP_H01:     GPP_H1_STRAP */
	PAD_CFG_GPO(GPP_H01, 0, PLTRST),
	/* GPP_H02:     GPP_H2_STRAP */
	PAD_CFG_GPO(GPP_H02, 1, PLTRST),
	/* GPP_H03:     SOC_SPKR_INT_ODL */
	PAD_CFG_GPI(GPP_H03, NONE, DEEP),
	/* GPP_H04:     NC */
	PAD_NC(GPP_H04, NONE),
	/* GPP_H05:     NC */
	PAD_NC(GPP_H05, NONE),
	/* GPP_H06:     I2C3_SDA_PSS */
	PAD_CFG_NF(GPP_H06, NONE, DEEP, NF1),
	/* GPP_H07:     I2C3_SCL_PSS */
	PAD_CFG_NF(GPP_H07, NONE, DEEP, NF1),
	/* GPP_H08:     UART0_BUF_RXD */
	PAD_CFG_NF(GPP_H08, NONE, DEEP, NF1),
	/* GPP_H09:     UART0_BUF_TXD */
	PAD_CFG_NF(GPP_H09, NONE, DEEP, NF1),
	/* GPP_H10:     NC */
	PAD_NC(GPP_H10, NONE),
	/* GPP_H11:     NC */
	PAD_NC(GPP_H11, NONE),
	/* GPP_H13:     CPU_C10_GATE_N_R */
	PAD_CFG_NF(GPP_H13, NONE, DEEP, NF1),
	/* GPP_H14:     NC */
	PAD_NC(GPP_H14, NONE),
	/* GPP_H15:     NC */
	PAD_NC(GPP_H15, NONE),
	/* GPP_H16:     NC */
	PAD_NC(GPP_H16, NONE),
	/* GPP_H17:     SOC_HP_INT_L */
	PAD_CFG_GPI_INT(GPP_H17, NONE, PLTRST, EDGE_BOTH),
	/* GPP_H19:     I3C0_SDA_HDR */
	PAD_CFG_NF(GPP_H19, NONE, DEEP, NF1),
	/* GPP_H20:     I3C0_SCL_HDR */
	PAD_CFG_NF(GPP_H20, NONE, DEEP, NF1),
	/* GPP_H21:     CAL_SDA_IN */
	PAD_CFG_NF(GPP_H21, NONE, DEEP, NF1),
	/* GPP_H22:     CAL_SCL_IN */
	PAD_CFG_NF(GPP_H22, NONE, DEEP, NF1),

	/* GPP_S00:     I2S_SPK_AUDIO_R_TX */
	PAD_CFG_NF(GPP_S00, NONE, DEEP, NF6),
	/* GPP_S01:     I2S_SPK_AUDIO_R_RX */
	PAD_CFG_NF(GPP_S01, NONE, DEEP, NF6),
	/* GPP_S02:     I2S_SPK_BCLK*/
	PAD_CFG_NF(GPP_S02, NONE, DEEP, NF6),
	/* GPP_S03:     I2S_SPK_LRCK */
	PAD_CFG_NF(GPP_S03, NONE, DEEP, NF6),
	/* GPP_S04:	DMIC_CLK_A0 */
	PAD_CFG_NF(GPP_S04, NONE, DEEP, NF5),
	/* GPP_S05:	DMIC_DATA_0 */
	PAD_CFG_NF(GPP_S05, NONE, DEEP, NF5),
	/* GPP_S06:     NC */
	PAD_NC(GPP_S06, NONE),
	/* GPP_S07:     NC */
	PAD_NC(GPP_S07, NONE),

	/* GPP_V00:     PM_BATLOW_N */
	PAD_CFG_NF(GPP_V00, NONE, DEEP, NF1),
	/* GPP_V01:     BC_ACOK_MCP */
	PAD_CFG_NF(GPP_V01, NONE, DEEP, NF1),
	/* GPP_V02:     LANWAKE_N_R */
	PAD_CFG_NF(GPP_V02, NONE, DEEP, NF1),
	/* GPP_V03:     PWRBTN_MCP_N */
	PAD_CFG_NF(GPP_V03, NONE, DEEP, NF1),
	/* GPP_V04:     PM_SLP_S3_N */
	PAD_CFG_NF(GPP_V04, NONE, DEEP, NF1),
	/* GPP_V05:     PM_SLP_S4_N */
	PAD_CFG_NF(GPP_V05, NONE, DEEP, NF1),
	/* GPP_V06:     PM_SLP_A_N */
	PAD_CFG_NF(GPP_V06, NONE, DEEP, NF1),
	/* GPP_V07:     SUSCLK */
	PAD_CFG_NF(GPP_V07, NONE, DEEP, NF1),
	/* GPP_V08:     SLP_WLAN_N */
	PAD_CFG_NF(GPP_V08, NONE, DEEP, NF1),
	/* GPP_V09:     PM_SLP_S5_N */
	PAD_CFG_NF(GPP_V09, NONE, DEEP, NF1),
	/* GPP_V10:     LANPHYPC_R_N */
	PAD_CFG_NF(GPP_V10, NONE, DEEP, NF1),
	/* GPP_V11:     PM_SLP_LAN_N */
	PAD_CFG_NF(GPP_V11, NONE, DEEP, NF1),
	/* GPP_V12:     WAKE_N */
	PAD_CFG_NF(GPP_V12, NONE, DEEP, NF1),
	/* GPP_V13:     GPP_V13_CATERR_N */
	PAD_CFG_NF(GPP_V13, NONE, DEEP, NF1),
	/* GPP_V14:     GPP_V14_FORCEPR_N */
	PAD_CFG_NF(GPP_V14, NONE, DEEP, NF1),
	/* GPP_V15:     GPP_V15_THERMTRIP_N */
	PAD_CFG_NF(GPP_V15, NONE, DEEP, NF1),
	/* GPP_V16:     GPP_V16_VCCST_EN */
	PAD_CFG_NF(GPP_V16, NONE, DEEP, NF1),
	/* GPP_V17:     SLP_S0_GATE_R */
	PAD_CFG_GPO(GPP_V17, 1, PLTRST),
};

/* Early pad configuration in bootblock */
static const struct pad_config early_gpio_table[] = {
	/* GPP_B14:     MOD_TCSS2_DISP_HPD4 */
	PAD_CFG_NF(GPP_B14, NONE, DEEP, NF2),
	/* GPP_C22:     MOD_TCSS2_LS_TX_DDC_SCL */
	PAD_CFG_NF(GPP_C22, NONE, DEEP, NF2),
	/* GPP_C23:     MOD_TCSS2_LS_RX_DDC_SDA */
	PAD_CFG_NF(GPP_C23, NONE, DEEP, NF2),
	/* GPP_H08:     UART0_BUF_RXD */
	PAD_CFG_NF(GPP_H08, NONE, DEEP, NF1),
	/* GPP_H09:     UART0_BUF_TXD */
	PAD_CFG_NF(GPP_H09, NONE, DEEP, NF1),
	/* GPP_H06: I2C3_SDA_PSS */
	PAD_CFG_NF(GPP_H06, NONE, DEEP, NF1),
	/* GPP_H07: I2C3_SCL_PSS */
	PAD_CFG_NF(GPP_H07, NONE, DEEP, NF1),
	/* GPP_E02: GSC_SOC_INT_ODL */
	PAD_CFG_GPI_APIC(GPP_E02, NONE, PLTRST, LEVEL, INVERT),
};

/* Pad configuration in romstage */
static const struct pad_config romstage_gpio_table[] = {
	/* GPP_B16:     EN_PP3300_SSD */
	PAD_CFG_GPO(GPP_B16, 1, PLTRST),
	/* GPP_B09:     SSD_GEN4_PERST_L */
	PAD_CFG_GPO(GPP_B09, 1, PLTRST),
};

const struct pad_config *variant_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(gpio_table);
	return gpio_table;
}

const struct pad_config *variant_early_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(early_gpio_table);
	return early_gpio_table;
}

/* Create the stub for romstage gpio, typically use for power sequence */
const struct pad_config *variant_romstage_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(romstage_gpio_table);
	return romstage_gpio_table;
}

static const struct cros_gpio cros_gpios[] = {
	CROS_GPIO_REC_AL(CROS_GPIO_VIRTUAL, CROS_GPIO_DEVICE0_NAME),
	CROS_GPIO_REC_AL(CROS_GPIO_VIRTUAL, CROS_GPIO_DEVICE1_NAME),
	CROS_GPIO_REC_AL(CROS_GPIO_VIRTUAL, CROS_GPIO_DEVICE2_NAME),
	CROS_GPIO_REC_AL(CROS_GPIO_VIRTUAL, CROS_GPIO_DEVICE3_NAME),
	CROS_GPIO_WP_AH(GPIO_PCH_WP, CROS_GPIO_DEVICE4_NAME),
};

DECLARE_CROS_GPIOS(cros_gpios);
