/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef __MAINBOARD_GOOGLE_RAURU_GPIO_H__
#define __MAINBOARD_GOOGLE_RAURU_GPIO_H__

#include <soc/gpio.h>

#define GPIO_RSVD_GPI0			GPIO(EINT0)
#define GPIO_EC_AP_DSI_HPD_OD		GPIO(EINT1)
#define GPIO_RSVD_GPI2			GPIO(EINT2)
#define GPIO_AP_WP_ODL			GPIO(EINT3)
#define GPIO_ALS_INT_SCP_ODL		GPIO(EINT4)
#define GPIO_LID_ACCEL_INT_SCP_L	GPIO(EINT5)
#define GPIO_IMU_INT_SCP_L		GPIO(EINT6)
#define GPIO_TCHSCR_INT_1V8_ODL		GPIO(EINT7)
#define GPIO_TCHPAD_INT_ODL		GPIO(EINT8)
#define GPIO_SPKR_INT_ODL		GPIO(EINT9)
#define GPIO_HP_INT_ODL			GPIO(EINT10)
#define GPIO_SD_CD_AP_ODL		GPIO(EINT11)
#define GPIO_FP_AP_INT_1V8_S3_ODL	GPIO(EINT12)
#define GPIO_EDP_HPD_1V8		GPIO(EINT13)
#define GPIO_SAR_INT_ODL		GPIO(EINT14)
#define GPIO_RSVD_GPI15			GPIO(EINT15)
#define GPIO_RSVD_GPI16			GPIO(EINT16)
#define GPIO_RSVD_GPI17			GPIO(EINT17)
#define GPIO_GSC_AP_INT_ODL		GPIO(EINT18)
#define GPIO_EC_AP_INT_ODL		GPIO(EINT19)
#define GPIO_RSVD_GPI20			GPIO(EINT20)
#define GPIO_RSVD_GPI21			GPIO(EINT21)
#define GPIO_RSVD_GPI22			GPIO(EINT22)
#define GPIO_EC_AP_DP_HPD_OD		GPIO(EINT32)
#define GPIO_PCIE_SSD_WAKE_OBFF_1V8_ODL		GPIO(BPI_D_BUS0)
#define GPIO_PCIE_SSD_CLKREQ_1V8_ODL		GPIO(BPI_D_BUS2)
#define GPIO_PCIE_WLAN_WAKE_OBFF_1V2_ODL	GPIO(PCIE0_WAKEN)
#define GPIO_PCIE_WLAN_CLKREQ_1V2_ODL		GPIO(PCIE0_CLKREQN)

#define GPIO_BEEP_ON		GPIO(PERIPHERAL_EN1)
#define GPIO_EN_SPKR		GPIO(PERIPHERAL_EN0)
#define GPIO_XHCI_INIT_DONE	GPIO(EINT28)
#define GPIO_AP_EC_WARM_RST_REQ GPIO(EINT29)
#define GPIO_FP_RST_1V8_S3_L	GPIO(EINT26)
#define GPIO_AP_FP_FW_UP_STRAP	GPIO(EINT27)
#define GPIO_AP_SUSPEND_L	GPIO(EINT38)
#define GPIO_EN_PWR_FP		GPIO(PERIPHERAL_EN3)
#define GPIO_BL_PWM_1V8		GPIO(DISP_PWM)

#define GPIO_AP_EDP_BKLTEN	GPIO(PERIPHERAL_EN4)
#define GPIO_EN_PP3300_EDP_X	GPIO(PERIPHERAL_EN2)
#define GPIO_EDP_HPD_1V8	GPIO(EINT13)
#define GPIO_LCM_RST_1V8_L	GPIO(LCM_RST)
#define GPIO_EN_PPVAR_MIPI_DISP	GPIO(EINT25)

#define GPIO_I2SI4_BCK		GPIO(I2SIN1_BCK)
#define GPIO_I2SI4_LRCK		GPIO(I2SIN1_LRCK)
#define GPIO_I2SO4_D0		GPIO(I2SOUT1_DO)

#define GPIO_I2SI6_MCK		GPIO(I2SIN0_MCK)
#define GPIO_I2SI6_BCK		GPIO(I2SIN0_BCK)
#define GPIO_I2SI6_LRCK		GPIO(I2SIN0_LRCK)
#define GPIO_I2SO6_D0		GPIO(I2SOUT0_DO)

void setup_chromeos_gpios(void);

#endif
