/** @file FspmUpd.h

 @copyright
  Copyright (c) 2020 - 2023, Intel Corporation. All rights reserved.<BR>

  SPDX-License-Identifier: BSD-2-Clause-Patent

  This file is automatically generated. Please do NOT modify !!!

**/


#ifndef __FSPMUPD_H__
#define __FSPMUPD_H__

#include <FspUpd.h>

#pragma pack(1)


#include <MemInfoHob.h>

///
/// The ChipsetInit Info structure provides the information of ME ChipsetInit CRC and BIOS ChipsetInit CRC.
///
typedef struct {
  UINT8             Revision;         ///< Chipset Init Info Revision
  UINT8             Rsvd[3];          ///< Reserved
  UINT16            MeChipInitCrc;    ///< 16 bit CRC value of MeChipInit Table
  UINT16            BiosChipInitCrc;  ///< 16 bit CRC value of PchChipInit Table
} CHIPSET_INIT_INFO;


/** Fsp M Configuration
**/
typedef struct {

/** Offset 0x0040 - Platform Reserved Memory Size
  The minimum platform memory size required to pass control into DXE
**/
  UINT64                      PlatformMemorySize;

/** Offset 0x0048 - SPD Data Length
  Length of SPD Data
  0x100:256 Bytes, 0x200:512 Bytes, 0x400:1024 Bytes
**/
  UINT16                      MemorySpdDataLen;

/** Offset 0x004A - Enable above 4GB MMIO resource support
  Enable/disable above 4GB MMIO resource support
  $EN_DIS
**/
  UINT8                       EnableAbove4GBMmio;

/** Offset 0x004B - Enable/Disable CrashLog Device 10
  Enable(Default): Enable CPU CrashLog Device 10, Disable: Disable CPU CrashLog
  $EN_DIS
**/
  UINT8                       CpuCrashLogDevice;

/** Offset 0x004C - Memory SPD Pointer Controller 0 Channel 0 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked
  as 00 [ALIAS_NAME MemorySpdPtr00]
**/
  UINT32                      MemorySpdPtr000;

/** Offset 0x0050 - Memory SPD Pointer Controller 0 Channel 0 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked
  as 00 [ALIAS_NAME MemorySpdPtr01]
**/
  UINT32                      MemorySpdPtr001;

/** Offset 0x0054 - Memory SPD Pointer Controller 0 Channel 1 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked
  as 00 [ALIAS_NAME MemorySpdPtr02]
**/
  UINT32                      MemorySpdPtr010;

/** Offset 0x0058 - Memory SPD Pointer Controller 0 Channel 1 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked
  as 00 [ALIAS_NAME MemorySpdPtr03]
**/
  UINT32                      MemorySpdPtr011;

/** Offset 0x005C - Memory SPD Pointer Controller 0 Channel 2 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked
  as 00 [ALIAS_NAME MemorySpdPtr04]
**/
  UINT32                      MemorySpdPtr020;

/** Offset 0x0060 - Memory SPD Pointer Controller 0 Channel 2 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked
  as 00 [ALIAS_NAME MemorySpdPtr05]
**/
  UINT32                      MemorySpdPtr021;

/** Offset 0x0064 - Memory SPD Pointer Controller 0 Channel 3 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked
  as 00 [ALIAS_NAME MemorySpdPtr06]
**/
  UINT32                      MemorySpdPtr030;

/** Offset 0x0068 - Memory SPD Pointer Controller 0 Channel 3 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked
  as 00 [ALIAS_NAME MemorySpdPtr07]
**/
  UINT32                      MemorySpdPtr031;

/** Offset 0x006C - Memory SPD Pointer Controller 1 Channel 0 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked
  as 00 [ALIAS_NAME MemorySpdPtr08]
**/
  UINT32                      MemorySpdPtr100;

/** Offset 0x0070 - Memory SPD Pointer Controller 1 Channel 0 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked
  as 00 [ALIAS_NAME MemorySpdPtr09]
**/
  UINT32                      MemorySpdPtr101;

/** Offset 0x0074 - Memory SPD Pointer Controller 1 Channel 1 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked
  as 00 [ALIAS_NAME MemorySpdPtr10]
**/
  UINT32                      MemorySpdPtr110;

/** Offset 0x0078 - Memory SPD Pointer Controller 1 Channel 1 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked
  as 00 [ALIAS_NAME MemorySpdPtr11]
**/
  UINT32                      MemorySpdPtr111;

/** Offset 0x007C - Memory SPD Pointer Controller 1 Channel 2 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked
  as 00 [ALIAS_NAME MemorySpdPtr12]
**/
  UINT32                      MemorySpdPtr120;

/** Offset 0x0080 - Memory SPD Pointer Controller 1 Channel 2 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked
  as 00 [ALIAS_NAME MemorySpdPtr13]
**/
  UINT32                      MemorySpdPtr121;

/** Offset 0x0084 - Memory SPD Pointer Controller 1 Channel 3 Dimm 0
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked
  as 00 [ALIAS_NAME MemorySpdPtr14]
**/
  UINT32                      MemorySpdPtr130;

/** Offset 0x0088 - Memory SPD Pointer Controller 1 Channel 3 Dimm 1
  Pointer to SPD data, will be used only when SpdAddressTable SPD Address are marked
  as 00 [ALIAS_NAME MemorySpdPtr15]
**/
  UINT32                      MemorySpdPtr131;

/** Offset 0x008C - RcompResistor settings
  Indicates  RcompResistor settings: Board-dependent
**/
  UINT16                      RcompResistor;

/** Offset 0x008E - RcompTarget settings
  RcompTarget settings: board-dependent
**/
  UINT16                      RcompTarget[5];

/** Offset 0x0098 - Dqs Map CPU to DRAM MC 0 CH 0
  Set Dqs mapping relationship between CPU and DRAM, Channel 0: board-dependent [ALIAS_NAME
  DqsMapCpu2DramCh0]
**/
  UINT8                       DqsMapCpu2DramMc0Ch0[2];

/** Offset 0x009A - Dqs Map CPU to DRAM MC 0 CH 1
  Set Dqs mapping relationship between CPU and DRAM, Channel 1: board-dependent [ALIAS_NAME
  DqsMapCpu2DramCh1]
**/
  UINT8                       DqsMapCpu2DramMc0Ch1[2];

/** Offset 0x009C - Dqs Map CPU to DRAM MC 0 CH 2
  Set Dqs mapping relationship between CPU and DRAM, Channel 2: board-dependent [ALIAS_NAME
  DqsMapCpu2DramCh2]
**/
  UINT8                       DqsMapCpu2DramMc0Ch2[2];

/** Offset 0x009E - Dqs Map CPU to DRAM MC 0 CH 3
  Set Dqs mapping relationship between CPU and DRAM, Channel 3: board-dependent [ALIAS_NAME
  DqsMapCpu2DramCh3]
**/
  UINT8                       DqsMapCpu2DramMc0Ch3[2];

/** Offset 0x00A0 - Dqs Map CPU to DRAM MC 1 CH 0
  Set Dqs mapping relationship between CPU and DRAM, Channel 0: board-dependent [ALIAS_NAME
  DqsMapCpu2DramCh4]
**/
  UINT8                       DqsMapCpu2DramMc1Ch0[2];

/** Offset 0x00A2 - Dqs Map CPU to DRAM MC 1 CH 1
  Set Dqs mapping relationship between CPU and DRAM, Channel 1: board-dependent [ALIAS_NAME
  DqsMapCpu2DramCh5]
**/
  UINT8                       DqsMapCpu2DramMc1Ch1[2];

/** Offset 0x00A4 - Dqs Map CPU to DRAM MC 1 CH 2
  Set Dqs mapping relationship between CPU and DRAM, Channel 2: board-dependent [ALIAS_NAME
  DqsMapCpu2DramCh6]
**/
  UINT8                       DqsMapCpu2DramMc1Ch2[2];

/** Offset 0x00A6 - Dqs Map CPU to DRAM MC 1 CH 3
  Set Dqs mapping relationship between CPU and DRAM, Channel 3: board-dependent [ALIAS_NAME
  DqsMapCpu2DramCh7]
**/
  UINT8                       DqsMapCpu2DramMc1Ch3[2];

/** Offset 0x00A8 - Dq Map CPU to DRAM MC 0 CH 0
  Set Dq mapping relationship between CPU and DRAM, Channel 0: board-dependent [ALIAS_NAME
  DqMapCpu2DramCh0]
**/
  UINT8                       DqMapCpu2DramMc0Ch0[16];

/** Offset 0x00B8 - Dq Map CPU to DRAM MC 0 CH 1
  Set Dq mapping relationship between CPU and DRAM, Channel 1: board-dependent [ALIAS_NAME
  DqMapCpu2DramCh1]
**/
  UINT8                       DqMapCpu2DramMc0Ch1[16];

/** Offset 0x00C8 - Dq Map CPU to DRAM MC 0 CH 2
  Set Dq mapping relationship between CPU and DRAM, Channel 2: board-dependent [ALIAS_NAME
  DqMapCpu2DramCh2]
**/
  UINT8                       DqMapCpu2DramMc0Ch2[16];

/** Offset 0x00D8 - Dq Map CPU to DRAM MC 0 CH 3
  Set Dq mapping relationship between CPU and DRAM, Channel 3: board-dependent [ALIAS_NAME
  DqMapCpu2DramCh3]
**/
  UINT8                       DqMapCpu2DramMc0Ch3[16];

/** Offset 0x00E8 - Dq Map CPU to DRAM MC 1 CH 0
  Set Dq mapping relationship between CPU and DRAM, Channel 0: board-dependent [ALIAS_NAME
  DqMapCpu2DramCh4]
**/
  UINT8                       DqMapCpu2DramMc1Ch0[16];

/** Offset 0x00F8 - Dq Map CPU to DRAM MC 1 CH 1
  Set Dq mapping relationship between CPU and DRAM, Channel 1: board-dependent [ALIAS_NAME
  DqMapCpu2DramCh5]
**/
  UINT8                       DqMapCpu2DramMc1Ch1[16];

/** Offset 0x0108 - Dq Map CPU to DRAM MC 1 CH 2
  Set Dq mapping relationship between CPU and DRAM, Channel 2: board-dependent [ALIAS_NAME
  DqMapCpu2DramCh6]
**/
  UINT8                       DqMapCpu2DramMc1Ch2[16];

/** Offset 0x0118 - Dq Map CPU to DRAM MC 1 CH 3
  Set Dq mapping relationship between CPU and DRAM, Channel 3: board-dependent [ALIAS_NAME
  DqMapCpu2DramCh7]
**/
  UINT8                       DqMapCpu2DramMc1Ch3[16];

/** Offset 0x0128 - Dqs Pins Interleaved Setting
  Indicates DqPinsInterleaved setting: board-dependent
  $EN_DIS
**/
  UINT8                       DqPinsInterleaved;

/** Offset 0x0129 - Smram Mask
  The SMM Regions AB-SEG and/or H-SEG reserved
  0: Neither, 1:AB-SEG, 2:H-SEG, 3: Both
**/
  UINT8                       SmramMask;

/** Offset 0x012A - MRC Fast Boot
  Enables/Disable the MRC fast path thru the MRC
  $EN_DIS
**/
  UINT8                       MrcFastBoot;

/** Offset 0x012B - Rank Margin Tool per Task
  This option enables the user to execute Rank Margin Tool per major training step
  in the MRC.
  $EN_DIS
**/
  UINT8                       RmtPerTask;

/** Offset 0x012C - Training Trace
  This option enables the trained state tracing feature in MRC.  This feature will
  print out the key training parameters state across major training steps.
  $EN_DIS
**/
  UINT8                       TrainTrace;

/** Offset 0x012D
**/
  UINT8                       UnusedUpdSpace0[3];

/** Offset 0x0130 - Intel Enhanced Debug
  <b>@deprecated</b> - Not used and has no effect
  0 : Disable, 0x400000 : Enable
**/
  UINT32                      IedSize;

/** Offset 0x0134 - Tseg Size
  Size of SMRAM memory reserved. 0x400000 for Release build and 0x1000000 for Debug build
  0x0400000:4MB, 0x01000000:16MB
**/
  UINT32                      TsegSize;

/** Offset 0x0138 - MMIO Size
  Size of MMIO space reserved for devices. 0(Default)=Auto, non-Zero=size in MB
**/
  UINT16                      MmioSize;

/** Offset 0x013A - Probeless Trace
  Probeless Trace: 0=Disabled, 1=Enable. Enabling Probeless Trace will reserve 128MB.
  This also requires IED to be enabled.
  $EN_DIS
**/
  UINT8                       ProbelessTrace;

/** Offset 0x013B - Enable SMBus
  Enable/disable SMBus controller.
  $EN_DIS
**/
  UINT8                       SmbusEnable;

/** Offset 0x013C - Spd Address Tabl
  Specify SPD Address table for CH0D0/CH0D1/CH1D0&CH1D1. MemorySpdPtr will be used
  if SPD Address is 00
**/
  UINT8                       SpdAddressTable[16];

/** Offset 0x014C - Platform Debug Consent
  To 'opt-in' for debug, please select 'Enabled' with the desired debug probe type.
  Enabling this BIOS option may alter the default value of other debug-related BIOS
  options.\Manual: Do not use Platform Debug Consent to override other debug-relevant
  policies, but the user must set each debug option manually, aimed at advanced users.\n
  Note: DCI OOB (aka BSSB) uses CCA probe;[DCI OOB+DbC] and [USB2 DbC] have the same setting.
  0:Disabled, 1:Enabled (DCI OOB+[DbC]), 2:Enabled (DCI OOB), 3:Enabled (USB3 DbC),
  4:Enabled (XDP/MIPI60), 5:Enabled (USB2 DbC), 6:Enable (2-wire DCI OOB), 7:Manual
**/
  UINT8                       PlatformDebugConsent;

/** Offset 0x014D - DCI Enable
  Determine if to enable DCI debug from host
  $EN_DIS
**/
  UINT8                       DciEn;

/** Offset 0x014E - DCI DbC Mode
  Disabled: Clear both USB2/3DBCEN; USB2: set USB2DBCEN; USB3: set USB3DBCEN; Both:
  Set both USB2/3DBCEN; No Change: Comply with HW value
  0:Disabled, 1:USB2 DbC, 2:USB3 DbC, 3:Both, 4:No Change
**/
  UINT8                       DciDbcMode;

/** Offset 0x014F - Enable DCI ModPHY Power Gate
  Enable ModPHY Power Gate when DCI is enabled
  $EN_DIS
**/
  UINT8                       DciModphyPg;

/** Offset 0x0150 - USB3 Type-C UFP2DFP Kernel/Platform Debug Support
  This BIOS option enables kernel and platform debug for USB3 interface over a UFP
  Type-C receptacle, select 'No Change' will do nothing to UFP2DFP setting.
  0:Disabled, 1:Enabled, 2:No Change
**/
  UINT8                       DciUsb3TypecUfpDbg;

/** Offset 0x0151 - PCH Trace Hub Mode
  Select 'Host Debugger' if Trace Hub is used with host debugger tool or 'Target Debugger'
  if Trace Hub is used by target debugger software or 'Disable' trace hub functionality.
  0: Disable, 1: Target Debugger Mode, 2: Host Debugger Mode
**/
  UINT8                       PchTraceHubMode;

/** Offset 0x0152 - PCH Trace Hub Memory Region 0 buffer Size
  Specify size of Pch trace memory region 0 buffer, the size can be 0, 1MB, 8MB, 64MB,
  128MB, 256MB, 512MB. Note : Limitation of total buffer size (PCH + CPU) is 512MB.
  0:0, 1:1MB, 2:8MB, 3:64MB, 4:128MB, 5:256MB, 6:512MB
**/
  UINT8                       PchTraceHubMemReg0Size;

/** Offset 0x0153 - PCH Trace Hub Memory Region 1 buffer Size
  Specify size of Pch trace memory region 1 buffer, the size can be 0, 1MB, 8MB, 64MB,
  128MB, 256MB, 512MB. Note : Limitation of total buffer size (PCH + CPU) is 512MB.
  0:0, 1:1MB, 2:8MB, 3:64MB, 4:128MB, 5:256MB, 6:512MB
**/
  UINT8                       PchTraceHubMemReg1Size;

/** Offset 0x0154 - HD Audio DMIC Link Clock Select
  Determines DMIC<N> Clock Source. 0: Both, 1: ClkA, 2: ClkB
  0: Both, 1: ClkA, 2: ClkB
**/
  UINT8                       PchHdaAudioLinkDmicClockSelect[2];

/** Offset 0x0156 - PchPreMemRsvd
  Reserved for PCH Pre-Mem Reserved
  $EN_DIS
**/
  UINT8                       PchPreMemRsvd[5];

/** Offset 0x015B - State of X2APIC_OPT_OUT bit in the DMAR table
  0=Disable/Clear, 1=Enable/Set
  $EN_DIS
**/
  UINT8                       X2ApicOptOut;

/** Offset 0x015C - State of DMA_CONTROL_GUARANTEE bit in the DMAR table
  0=Disable/Clear, 1=Enable/Set
  $EN_DIS
**/
  UINT8                       DmaControlGuarantee;

/** Offset 0x015D
**/
  UINT8                       UnusedUpdSpace1[3];

/** Offset 0x0160 - Base addresses for VT-d function MMIO access
  Base addresses for VT-d MMIO access per VT-d engine
**/
  UINT32                      VtdBaseAddress[9];

/** Offset 0x0184 - Disable VT-d
  0=Enable/FALSE(VT-d enabled), 1=Disable/TRUE (VT-d disabled)
  $EN_DIS
**/
  UINT8                       VtdDisable;

/** Offset 0x0185 - Vtd Programming for Igd
  1=Enable/TRUE (Igd VT-d Bar programming enabled), 0=Disable/FLASE (Igd VT-d Bar
  programming disabled)
  $EN_DIS
**/
  UINT8                       VtdIgdEnable;

/** Offset 0x0186 - Vtd Programming for Ipu
  1=Enable/TRUE (Ipu VT-d Bar programming enabled), 0=Disable/FLASE (Ipu VT-d Bar
  programming disabled)
  $EN_DIS
**/
  UINT8                       VtdIpuEnable;

/** Offset 0x0187 - Vtd Programming for Iop
  1=Enable/TRUE (Iop VT-d Bar programming enabled), 0=Disable/FLASE (Iop VT-d Bar
  programming disabled)
  $EN_DIS
**/
  UINT8                       VtdIopEnable;

/** Offset 0x0188 - Vtd Programming for ITbt
  1=Enable/TRUE (ITbt VT-d Bar programming enabled), 0=Disable/FLASE (ITbt VT-d Bar
  programming disabled)
  $EN_DIS
**/
  UINT8                       VtdItbtEnable;

/** Offset 0x0189 - Internal Graphics Pre-allocated Memory
  Size of memory preallocated for internal graphics.
  0x00:0MB, 0x01:32MB, 0x02:64MB, 0x03:96MB, 0x04:128MB, 0x05:160MB, 0xF0:4MB, 0xF1:8MB,
  0xF2:12MB, 0xF3:16MB, 0xF4:20MB, 0xF5:24MB, 0xF6:28MB, 0xF7:32MB, 0xF8:36MB, 0xF9:40MB,
  0xFA:44MB, 0xFB:48MB, 0xFC:52MB, 0xFD:56MB, 0xFE:60MB
**/
  UINT8                       IgdDvmt50PreAlloc;

/** Offset 0x018A - Internal Graphics
  Enable/disable internal graphics.
  $EN_DIS
**/
  UINT8                       InternalGfx;

/** Offset 0x018B - Aperture Size
  Select the Aperture Size.
  0:128 MB, 1:256 MB, 3:512 MB, 7:1024 MB, 15: 2048 MB
**/
  UINT8                       ApertureSize;

/** Offset 0x018C - Board Type
  MrcBoardType, Options are 0=Mobile/Mobile Halo, 1=Desktop/DT Halo, 5=ULT/ULX/Mobile
  Halo, 7=UP Server
  0:Mobile/Mobile Halo, 1:Desktop/DT Halo, 5:ULT/ULX/Mobile Halo, 7:UP Server
**/
  UINT8                       UserBd;

/** Offset 0x018D
**/
  UINT8                       UnusedUpdSpace2;

/** Offset 0x018E - DDR Frequency Limit
  Maximum Memory Frequency Selections in Mhz. Options are 1067, 1333, 1600, 1867,
  2133, 2400, 2667, 2933, 3200 and 0 for Auto.
  1067:1067, 1333:1333, 1600:1600, 1867:1867, 2133:2133, 2400:2400, 2667:2667, 2933:2933,
  3200:3200, 0:Auto
**/
  UINT16                      DdrFreqLimit;

/** Offset 0x0190 - SA GV
  System Agent dynamic frequency support and when enabled memory will be training
  at three different frequencies.
  0:Disabled, 1:FixedPoint0, 2:FixedPoint1, 3:FixedPoint2, 4:FixedPoint3, 5:Enabled
**/
  UINT8                       SaGv;

/** Offset 0x0191 - Memory Test on Warm Boot
  Run Base Memory Test on Warm Boot
  0:Disable, 1:Enable
**/
  UINT8                       MemTestOnWarmBoot;

/** Offset 0x0192 - DDR Speed Control
  DDR Frequency and Gear control for all SAGV points.
  0:Auto, 1:Manual
**/
  UINT8                       DdrSpeedControl;

/** Offset 0x0193 - Rank Margin Tool
  Enable/disable Rank Margin Tool.
  $EN_DIS
**/
  UINT8                       RMT;

/** Offset 0x0194 - Controller 0 Channel 0 DIMM Control
  Controller 1 Channel 0 DIMM Control Support - Enable or Disable Dimms on Channel A.
  0:Enable both DIMMs, 1:Disable DIMM0, 2:Disable DIMM1, 3:Disable both DIMMs [ALIAS_NAME
  DisableDimmCh0]
**/
  UINT8                       DisableDimmMc0Ch0;

/** Offset 0x0195 - Controller 0 Channel 1 DIMM Control
  Controller 1 Channel 1 DIMM Control Support - Enable or Disable Dimms on Channel B.
  0:Enable both DIMMs, 1:Disable DIMM0, 2:Disable DIMM1, 3:Disable both DIMMs [ALIAS_NAME
  DisableDimmCh1]
**/
  UINT8                       DisableDimmMc0Ch1;

/** Offset 0x0196 - Controller 0 Channel 2 DIMM Control
  Controller 0 Channel 2 DIMM Control Support - Enable or Disable Dimms on Channel A.
  0:Enable both DIMMs, 1:Disable DIMM0, 2:Disable DIMM1, 3:Disable both DIMMs [ALIAS_NAME
  DisableDimmCh2]
**/
  UINT8                       DisableDimmMc0Ch2;

/** Offset 0x0197 - Controller 0 Channel 3 DIMM Control
  Controller 0 Channel 3 DIMM Control Support - Enable or Disable Dimms on Channel B.
  0:Enable both DIMMs, 1:Disable DIMM0, 2:Disable DIMM1, 3:Disable both DIMMs [ALIAS_NAME
  DisableDimmCh3]
**/
  UINT8                       DisableDimmMc0Ch3;

/** Offset 0x0198 - Controller 1 Channel 0 DIMM Control
  Controller 1 Channel 0 DIMM Control Support - Enable or Disable Dimms on Channel A.
  0:Enable both DIMMs, 1:Disable DIMM0, 2:Disable DIMM1, 3:Disable both DIMMs [ALIAS_NAME
  DisableDimmCh4]
**/
  UINT8                       DisableDimmMc1Ch0;

/** Offset 0x0199 - Controller 1 Channel 1 DIMM Control
  Controller 1 Channel 1 DIMM Control Support - Enable or Disable Dimms on Channel B.
  0:Enable both DIMMs, 1:Disable DIMM0, 2:Disable DIMM1, 3:Disable both DIMMs [ALIAS_NAME
  DisableDimmCh5]
**/
  UINT8                       DisableDimmMc1Ch1;

/** Offset 0x019A - Controller 1 Channel 2 DIMM Control
  Controller 1 Channel 2 DIMM Control Support - Enable or Disable Dimms on Channel A.
  0:Enable both DIMMs, 1:Disable DIMM0, 2:Disable DIMM1, 3:Disable both DIMMs [ALIAS_NAME
  DisableDimmCh6]
**/
  UINT8                       DisableDimmMc1Ch2;

/** Offset 0x019B - Controller 1 Channel 3 DIMM Control
  Controller 1 Channel 3 DIMM Control Support - Enable or Disable Dimms on Channel B.
  0:Enable both DIMMs, 1:Disable DIMM0, 2:Disable DIMM1, 3:Disable both DIMMs [ALIAS_NAME
  DisableDimmCh7]
**/
  UINT8                       DisableDimmMc1Ch3;

/** Offset 0x019C - Scrambler Support
  This option enables data scrambling in memory.
  $EN_DIS
**/
  UINT8                       ScramblerSupport;

/** Offset 0x019D - SPD Profile Selected
  Select DIMM timing profile. Options are 0=Default Profile, 1=Custom Profile, 2=XMP
  Profile 1, 3=XMP Profile 2
  0:Default Profile, 1:Custom Profile, 2:XMP Profile 1, 3:XMP Profile 2
**/
  UINT8                       SpdProfileSelected;

/** Offset 0x019E - Memory Reference Clock
  100MHz, 133MHz.
  0:133MHz, 1:100MHz
**/
  UINT8                       RefClk;

/** Offset 0x019F
**/
  UINT8                       UnusedUpdSpace3;

/** Offset 0x01A0 - Memory Voltage
  DRAM voltage (Vdd) (supply voltage for input buffers and core logic of the DRAM
  chips) in millivolts. <b>0=Platform Default (no override)</b>, 1200=1.2V, 1350=1.35V etc.
  0:Default, 1200:1.20 Volts, 1250:1.25 Volts, 1300:1.30 Volts, 1350:1.35 Volts, 1400:1.40
  Volts, 1450:1.45 Volts, 1500:1.50 Volts, 1550:1.55 Volts, 1600:1.60 Volts, 1650:1.65 Volts
**/
  UINT16                      VddVoltage;

/** Offset 0x01A2 - Memory Ratio
  Automatic or the frequency will equal ratio times reference clock. Set to Auto to
  recalculate memory timings listed below.
  0:Auto, 4:4, 5:5, 6:6, 7:7, 8:8, 9:9, 10:10, 11:11, 12:12, 13:13, 14:14, 15:15
**/
  UINT8                       Ratio;

/** Offset 0x01A3 - tCL
  CAS Latency, 0: AUTO, max: 31. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT8                       tCL;

/** Offset 0x01A4 - tCWL
  Min CAS Write Latency Delay Time, 0: AUTO, max: 34. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT8                       tCWL;

/** Offset 0x01A5
**/
  UINT8                       UnusedUpdSpace4;

/** Offset 0x01A6 - tFAW
  Min Four Activate Window Delay Time, 0: AUTO, max: 63. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT16                      tFAW;

/** Offset 0x01A8 - tRAS
  RAS Active Time, 0: AUTO, max: 64. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT16                      tRAS;

/** Offset 0x01AA - tRCD/tRP
  RAS to CAS delay time and Row Precharge delay time, 0: AUTO, max: 63. Only used
  if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
**/
  UINT8                       tRCDtRP;

/** Offset 0x01AB
**/
  UINT8                       UnusedUpdSpace5;

/** Offset 0x01AC - tREFI
  Refresh Interval, 0: AUTO, max: 65535. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT16                      tREFI;

/** Offset 0x01AE - tRFC
  Min Refresh Recovery Delay Time, 0: AUTO, max: 1023. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT16                      tRFC;

/** Offset 0x01B0 - tRRD
  Min Row Active to Row Active Delay Time, 0: AUTO, max: 15. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT8                       tRRD;

/** Offset 0x01B1 - tRTP
  Min Internal Read to Precharge Command Delay Time, 0: AUTO, max: 15. DDR4 legal
  values: 5, 6, 7, 8, 9, 10, 12. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT8                       tRTP;

/** Offset 0x01B2 - tWR
  Min Write Recovery Time, 0: AUTO, legal values: 5, 6, 7, 8, 10, 12, 14, 16, 18,
  20, 24, 30, 34, 40. Only used if FspmUpd->FspmConfig.SpdProfileSelected == 1 (Custom Profile).
  0:Auto, 5:5, 6:6, 7:7, 8:8, 10:10, 12:12, 14:14, 16:16, 18:18, 20:20, 24:24, 30:30,
  34:34, 40:40
**/
  UINT8                       tWR;

/** Offset 0x01B3 - tWTR
  Min Internal Write to Read Command Delay Time, 0: AUTO, max: 28. Only used if FspmUpd->FspmConfig.SpdProfileSelected
  == 1 (Custom Profile).
**/
  UINT8                       tWTR;

/** Offset 0x01B4 - NMode
  System command rate, range 0-2, 0 means auto, 1 = 1N, 2 = 2N
**/
  UINT8                       NModeSupport;

/** Offset 0x01B5 - Enable Intel HD Audio (Azalia)
  0: Disable, 1: Enable (Default) Azalia controller
  $EN_DIS
**/
  UINT8                       PchHdaEnable;

/** Offset 0x01B6 - Enable PCH ISH Controller
  0: Disable, 1: Enable (Default) ISH Controller
  $EN_DIS
**/
  UINT8                       PchIshEnable;

/** Offset 0x01B7 - CPU Trace Hub Mode
  Select 'Host Debugger' if Trace Hub is used with host debugger tool or 'Target Debugger'
  if Trace Hub is used by target debugger software or 'Disable' trace hub functionality.
  0: Disable, 1:Target Debugger Mode, 2:Host Debugger Mode
**/
  UINT8                       CpuTraceHubMode;

/** Offset 0x01B8 - CPU Trace Hub Memory Region 0
  CPU Trace Hub Memory Region 0, The avaliable memory size is : 0MB, 1MB, 8MB, 64MB,
  128MB, 256MB, 512MB. Note : Limitation of total buffer size (CPU + PCH) is 512MB.
  0:0, 1:1MB, 2:8MB, 3:64MB, 4:128MB, 5:256MB, 6:512MB
**/
  UINT8                       CpuTraceHubMemReg0Size;

/** Offset 0x01B9 - CPU Trace Hub Memory Region 1
  CPU Trace Hub Memory Region 1. The avaliable memory size is : 0MB, 1MB, 8MB, 64MB,
  128MB, 256MB, 512MB. Note : Limitation of total buffer size (CPU + PCH) is 512MB.
  0:0, 1:1MB, 2:8MB, 3:64MB, 4:128MB, 5:256MB, 6:512MB
**/
  UINT8                       CpuTraceHubMemReg1Size;

/** Offset 0x01BA - SAGV Gear Ratio
  Gear Selection for SAGV points. 0 - Auto, 1-1 Gear 1, 2-Gear 2
**/
  UINT8                       SaGvGear[4];

/** Offset 0x01BE - SAGV Frequency
  SAGV Frequency per point in Mhz. 0 for Auto and a ratio of 133/100MHz: 1333/1300.
**/
  UINT16                      SaGvFreq[4];

/** Offset 0x01C6 - SAGV Disabled Gear Ratio
  Gear Selection for SAGV Disabled. 0 - Auto, 1-1 Gear 1, 2-Gear 2
**/
  UINT8                       GearRatio;

/** Offset 0x01C7 - HECI Timeouts
  0: Disable, 1: Enable (Default) timeout check for HECI
  $EN_DIS
**/
  UINT8                       HeciTimeouts;

/** Offset 0x01C8 - HECI1 BAR address
  BAR address of HECI1
**/
  UINT32                      Heci1BarAddress;

/** Offset 0x01CC - HECI2 BAR address
  BAR address of HECI2
**/
  UINT32                      Heci2BarAddress;

/** Offset 0x01D0 - HECI3 BAR address
  BAR address of HECI3
**/
  UINT32                      Heci3BarAddress;

/** Offset 0x01D4 - HG dGPU Power Delay
  HG dGPU delay interval after power enabling: 0=Minimal, 1000=Maximum, default is
  300=300 microseconds
**/
  UINT16                      HgDelayAfterPwrEn;

/** Offset 0x01D6 - HG dGPU Reset Delay
  HG dGPU delay interval for Reset complete: 0=Minimal, 1000=Maximum, default is 100=100
  microseconds
**/
  UINT16                      HgDelayAfterHoldReset;

/** Offset 0x01D8 - MMIO size adjustment for AUTO mode
  Positive number means increasing MMIO size, Negative value means decreasing MMIO
  size: 0 (Default)=no change to AUTO mode MMIO size
**/
  UINT16                      MmioSizeAdjustment;

/** Offset 0x01DA - PCIe ASPM programming will happen in relation to the Oprom
  (DEPRECATED)
  0:Before, 1:After
**/
  UINT8                       InitPcieAspmAfterOprom;

/** Offset 0x01DB - Selection of the primary display device
  0=iGFX, 1=PEG, 2=PCIe Graphics on PCH, 3(Default)=AUTO, 4=Hybrid Graphics
  0:iGFX, 1:PEG, 2:PCIe Graphics on PCH, 3:AUTO, 4:Hybrid Graphics
**/
  UINT8                       PrimaryDisplay;

/** Offset 0x01DC - Selection of PSMI Region size
  0=32MB, 1=288MB, 2=544MB, 3=800MB, 4=1024MB Default is 0
  0:32MB, 1:288MB, 2:544MB, 3:800MB, 4:1024MB
**/
  UINT8                       PsmiRegionSize;

/** Offset 0x01DD
**/
  UINT8                       UnusedUpdSpace6[3];

/** Offset 0x01E0 - Temporary MMIO address for GMADR
  Obsolete field now and it has been extended to 64 bit address, used GmAdr64
**/
  UINT32                      GmAdr;

/** Offset 0x01E4 - Temporary MMIO address for GTTMMADR
  The reference code will use this as Temporary MMIO address space to access GTTMMADR
  Registers.Platform should provide conflict free Temporary MMIO Range: GttMmAdr
  to (GttMmAdr + 2MB MMIO + 6MB Reserved + GttSize). Default is (GmAdr - (2MB MMIO
  + 6MB Reserved + GttSize)) to (GmAdr - 0x1) (Where GttSize = 8MB)
**/
  UINT32                      GttMmAdr;

/** Offset 0x01E8 - Selection of iGFX GTT Memory size
  1=2MB, 2=4MB, 3=8MB, Default is 3
  1:2MB, 2:4MB, 3:8MB
**/
  UINT16                      GttSize;

/** Offset 0x01EA
**/
  UINT8                       UnusedUpdSpace7[2];

/** Offset 0x01EC - Hybrid Graphics GPIO information for PEG 0
  Hybrid Graphics GPIO information for PEG 0, for Reset, power and wake GPIOs
**/
  UINT32                      CpuPcie0Rtd3Gpio[24];

/** Offset 0x024C - Enable/Disable MRC TXT dependency
  When enabled MRC execution will wait for TXT initialization to be done first. Disabled(0x0)(Default):
  MRC will not wait for TXT initialization, Enabled(0x1): MRC will wait for TXT initialization
  $EN_DIS
**/
  UINT8                       TxtImplemented;

/** Offset 0x024D - Enable/Disable SA OcSupport
  Enable: Enable SA OcSupport, Disable(Default): Disable SA OcSupport
  $EN_DIS
**/
  UINT8                       SaOcSupport;

/** Offset 0x024E - GT slice Voltage Mode
  0(Default): Adaptive, 1: Override
  0: Adaptive, 1: Override
**/
  UINT8                       GtVoltageMode;

/** Offset 0x024F - Maximum GTs turbo ratio override
  0(Default)=Minimal/Auto, 60=Maximum
**/
  UINT8                       GtMaxOcRatio;

/** Offset 0x0250 - The voltage offset applied to GT slice
  0(Default)=Minimal, 1000=Maximum
**/
  UINT16                      GtVoltageOffset;

/** Offset 0x0252 - The GT slice voltage override which is applied to the entire range of GT frequencies
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtVoltageOverride;

/** Offset 0x0254 - adaptive voltage applied during turbo frequencies
  0(Default)=Minimal, 2000=Maximum
**/
  UINT16                      GtExtraTurboVoltage;

/** Offset 0x0256 - voltage offset applied to the SA
  0(Default)=Minimal, 1000=Maximum
**/
  UINT16                      SaVoltageOffset;

/** Offset 0x0258 - PCIe root port Function number for Hybrid Graphics dGPU
  Root port Index number to indicate which PCIe root port has dGPU
**/
  UINT8                       RootPortIndex;

/** Offset 0x0259 - Realtime Memory Timing
  0(Default): Disabled, 1: Enabled. When enabled, it will allow the system to perform
  realtime memory timing changes after MRC_DONE.
  0: Disabled, 1: Enabled
**/
  UINT8                       RealtimeMemoryTiming;

/** Offset 0x025A - iTBT PCIe Multiple Segment setting
  When Disabled all the TBT PCIe RP are located at Segment0, When Enabled all the
  TBT PCIe RP are located at Segment1. <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       PcieMultipleSegmentEnabled;

/** Offset 0x025B - Enable/Disable SA IPU
  Enable(Default): Enable SA IPU, Disable: Disable SA IPU
  $EN_DIS
**/
  UINT8                       SaIpuEnable;

/** Offset 0x025C - IPU IMR Configuration
  0:IPU Camera, 1:IPU Gen Default is 0
  0:IPU Camera, 1:IPU Gen
**/
  UINT8                       SaIpuImrConfiguration;

/** Offset 0x025D - IMGU CLKOUT Configuration
  The configuration of IMGU CLKOUT, 0: Disable;<b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       ImguClkOutEn[6];

/** Offset 0x0263
**/
  UINT8                       UnusedUpdSpace8;

/** Offset 0x0264 - Enable PCIE RP Mask
  Enable/disable PCIE Root Ports. 0: disable, 1: enable. One bit for each port, bit0
  for port1, bit1 for port2, and so on.
**/
  UINT32                      CpuPcieRpEnableMask;

/** Offset 0x0268 - Assertion on Link Down GPIOs
  GPIO Assertion on Link Down. Disabled(0x0)(Default): Disable assertion on Link Down
  GPIOs, Enabled(0x1): Enable assertion on Link Down GPIOs
  0:Disable, 1:Enable
**/
  UINT8                       CpuPcieRpLinkDownGpios;

/** Offset 0x0269 - Enable ClockReq Messaging
  ClockReq Messaging. Disabled(0x0): Disable ClockReq Messaging, Enabled(0x1)(Default):
  Enable ClockReq Messaging [ALIAS_NAME RpClockReqMsgEnable]
  0:Disable, 1:Enable
**/
  UINT8                       CpuPcieRpClockReqMsgEnable;

/** Offset 0x026A - PCIE RP Pcie Speed
  Determines each PCIE Port speed capability. 0: Auto; 1: Gen1; 2: Gen2; 3: Gen3;
  4: Gen4 (see: CPU_PCIE_SPEED). [ALIAS_NAME RpPcieThresholdBytes]
**/
  UINT8                       CpuPcieRpPcieSpeed[4];

/** Offset 0x026E - Selection of PSMI Support On/Off
  0(Default) = FALSE, 1 = TRUE. When TRUE, it will allow the PSMI Support
  $EN_DIS
**/
  UINT8                       GtPsmiSupport;

/** Offset 0x026F - Selection of DiSM Region Size
  DiSM Size to be allocated for 2LM Sku Default is 0
  0:0GB, 1:1GB, 2:2GB, 3:3GB, 4:4GB, 5:5GB, 6:6GB, 7:7GB
**/
  UINT8                       DismSize;

/** Offset 0x0270 - Enable Display memory map programming for DFD Restore
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DfdRestoreEnable;

/** Offset 0x0271 - Program GPIOs for LFP on DDI port-A device
  0=Disabled,1(Default)=eDP, 2=MIPI DSI
  0:Disabled, 1:eDP, 2:MIPI DSI
**/
  UINT8                       DdiPortAConfig;

/** Offset 0x0272 - Program GPIOs for LFP on DDI port-B device
  0(Default)=Disabled,1=eDP, 2=MIPI DSI
  0:Disabled, 1:eDP, 2:MIPI DSI
**/
  UINT8                       DdiPortBConfig;

/** Offset 0x0273 - Enable or disable HPD of DDI port A
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPortAHpd;

/** Offset 0x0274 - Enable or disable HPD of DDI port B
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortBHpd;

/** Offset 0x0275 - Enable or disable HPD of DDI port C
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPortCHpd;

/** Offset 0x0276 - Enable or disable HPD of DDI port 1
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPort1Hpd;

/** Offset 0x0277 - Enable or disable HPD of DDI port 2
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort2Hpd;

/** Offset 0x0278 - Enable or disable HPD of DDI port 3
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort3Hpd;

/** Offset 0x0279 - Enable or disable HPD of DDI port 4
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort4Hpd;

/** Offset 0x027A - Enable or disable DDC of DDI port A
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPortADdc;

/** Offset 0x027B - Enable or disable DDC of DDI port B
  0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       DdiPortBDdc;

/** Offset 0x027C - Enable or disable DDC of DDI port C
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPortCDdc;

/** Offset 0x027D - Enable DDC setting of DDI Port 1
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort1Ddc;

/** Offset 0x027E - Enable DDC setting of DDI Port 2
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort2Ddc;

/** Offset 0x027F - Enable DDC setting of DDI Port 3
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort3Ddc;

/** Offset 0x0280 - Enable DDC setting of DDI Port 4
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       DdiPort4Ddc;

/** Offset 0x0281 - Enable Gt CLOS
  0(Default)=Disable, 1=Enable
  $EN_DIS
**/
  UINT8                       GtClosEnable;

/** Offset 0x0282
**/
  UINT8                       UnusedUpdSpace9[6];

/** Offset 0x0288 - Temporary MMIO address for GMADR
  The reference code will use this as Temporary MMIO address space to access GMADR
  Registers.Platform should provide conflict free Temporary MMIO Range: GmAdr to
  (GmAdr + ApertureSize). Default is (PciExpressBaseAddress - ApertureSize) to (PciExpressBaseAddress
  - 0x1) (Where ApertureSize = 256MB, 512MB, 1024MB and 2048MB)
**/
  UINT64                      GmAdr64;

/** Offset 0x0290 - Hybrid Graphics Slot Selection
  PEG or PCH Slot Selection for Hybrid Graphics
**/
  UINT8                       HgSlot;

/** Offset 0x0291 - DMI ASPM Configuration:{Combo
  Set ASPM Configuration
  0:Disabled, 1:L0s, 2:L1, 3:L1L0s
**/
  UINT8                       DmiAspm;

/** Offset 0x0292 - DMI ASPM Control Configuration:{Combo
  Set ASPM Control configuration
  0:Disabled, 1:L0s, 2:L1, 3:L1L0s
**/
  UINT8                       DmiAspmCtrl;

/** Offset 0x0293 - DMI ASPM L1 exit Latency
  Range: 0-7, 4 is default L1 exit Latency
**/
  UINT8                       DmiAspmL1ExitLatency;

/** Offset 0x0294 - Per-core HT Disable
  Defines the per-core HT disable mask where: 1 - Disable selected logical core HT,
  0 - is ignored. Input is in HEX and each bit maps to a logical core. Ex. A value
  of '1F' would disable HT for cores 4,3,2,1 and 0. Default is 0, all cores have
  HT enabled. Range is 0 - 0x7F for max 8 cores. You can only disable up to MAX_CORE_COUNT - 1.
**/
  UINT16                      PerCoreHtDisable;

/** Offset 0x0296 - DEKEL CDR Relock
  Enable/Disable CDR Relock. 0: Disable(Default); 1: Enable
**/
  UINT8                       CpuPcieRpCdrRelock[4];

/** Offset 0x029A -  Realtime Memory OverClock
  Disable/Enables Realtime Memory OverClock
  $EN_DIS
**/
  UINT8                       RealtimeMemoryOC;

/** Offset 0x029B - Xl1el
  Enable/Disable NewFom for DEKEL Programming. 0: Disable(Default); 1: Enable
**/
  UINT8                       CpuPcieNewFom[4];

/** Offset 0x029F - Xl1el
  Enable/Disable NewFomDisable. 0: Disable(Default); 1: Enable
**/
  UINT8                       CpuPcieIotgMode[4];

/** Offset 0x02A3 - SaPreMemProductionRsvd
  Reserved for SA Pre-Mem Production
  $EN_DIS
**/
  UINT8                       SaPreMemProductionRsvd[87];

/** Offset 0x02FA - DMI Max Link Speed
  Gen1(0x1): Limit Link to Gen1 Speed, Gen2(0x2): Limit Link to Gen2 Speed, (Default)
  Gen3(0x3):Limit Link to Gen3 Speed
  1:Gen1, 2:Gen2, 3:Gen3
**/
  UINT8                       DmiMaxLinkSpeed;

/** Offset 0x02FB - DMI Equalization Phase 2
  DMI Equalization Phase 2. (0x0): Disable phase 2, (0x1): Enable phase 2, (0x2)(Default):
  AUTO - Use the current default method
  0:Disable phase2, 1:Enable phase2, 2:Auto
**/
  UINT8                       DmiGen3EqPh2Enable;

/** Offset 0x02FC - DMI Gen3 Equalization Phase3
  DMI Gen3 Equalization Phase3. Auto(0x0)(Default): Use the current default method,
  HwEq(0x1): Use Adaptive Hardware Equalization, SwEq(0x2): Use Adaptive Software
  Equalization (Implemented in BIOS Reference Code), Static(0x3): Use the Static
  EQs provided in DmiGen3EndPointPreset array for Phase1 AND Phase3 (Instead of just
  Phase1), Disabled(0x4): Bypass Equalization Phase 3
  0:Auto, 1:HwEq, 2:SwEq, 3:StaticEq, 4:BypassPhase3
**/
  UINT8                       DmiGen3EqPh3Method;

/** Offset 0x02FD - Enable/Disable DMI GEN3 Static EQ Phase1 programming
  Program DMI Gen3 EQ Phase1 Static Presets. Disabled(0x0): Disable EQ Phase1 Static
  Presets Programming, Enabled(0x1)(Default): Enable  EQ Phase1 Static Presets Programming
  $EN_DIS
**/
  UINT8                       DmiGen3ProgramStaticEq;

/** Offset 0x02FE - DeEmphasis control for DMI
  DeEmphasis control for DMI. 0=-6dB, 1(Default)=-3.5 dB
  0: -6dB, 1: -3.5dB
**/
  UINT8                       DmiDeEmphasis;

/** Offset 0x02FF - DMI Gen3 Root port preset values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-9, 8 is default for each lane
**/
  UINT8                       DmiGen3RootPortPreset[8];

/** Offset 0x0307 - DMI Gen3 End port preset values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-9, 7 is default for each lane
**/
  UINT8                       DmiGen3EndPointPreset[8];

/** Offset 0x030F - DMI Gen3 End port Hint values per lane
  Used for programming DMI Gen3 Hint values per lane. Range: 0-6, 2 is default for each lane
**/
  UINT8                       DmiGen3EndPointHint[8];

/** Offset 0x0317 - DMI Gen3 RxCTLEp per-Bundle control
  Range: 0-15, 0 is default for each bundle, must be specified based upon platform design
**/
  UINT8                       DmiGen3RxCtlePeaking[4];

/** Offset 0x031B - BIST on Reset
  Enable or Disable BIST on Reset; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       BistOnReset;

/** Offset 0x031C - Skip Stop PBET Timer Enable/Disable
  Skip Stop PBET Timer; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       SkipStopPbet;

/** Offset 0x031D - C6DRAM power gating feature
  This policy indicates whether or not BIOS should allocate PRMRR memory for C6DRAM
  power gating feature.- 0: Don't allocate any PRMRR memory for C6DRAM power gating
  feature.- <b>1: Allocate PRMRR memory for C6DRAM power gating feature</b>.
  $EN_DIS
**/
  UINT8                       EnableC6Dram;

/** Offset 0x031E - Over clocking support
  Over clocking support; <b>0: Disable</b>; 1: Enable
  $EN_DIS
**/
  UINT8                       OcSupport;

/** Offset 0x031F - Over clocking Lock
  Over clocking Lock Enable/Disable; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       OcLock;

/** Offset 0x0320 - Maximum Core Turbo Ratio Override
  Maximum core turbo ratio override allows to increase CPU core frequency beyond the
  fused max turbo ratio limit. <b>0: Hardware defaults.</b> Range: 0-85
**/
  UINT8                       CoreMaxOcRatio;

/** Offset 0x0321 - Core voltage mode
  Core voltage mode; <b>0: Adaptive</b>; 1: Override.
  $EN_DIS
**/
  UINT8                       CoreVoltageMode;

/** Offset 0x0322 - Maximum clr turbo ratio override
  Maximum clr turbo ratio override allows to increase CPU clr frequency beyond the
  fused max turbo ratio limit. <b>0: Hardware defaults.</b>  Range: 0-85
**/
  UINT8                       RingMaxOcRatio;

/** Offset 0x0323 - Hyper Threading Enable/Disable
  Enable or Disable Hyper Threading; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       HyperThreading;

/** Offset 0x0324 - Enable or Disable CPU Ratio Override
  Enable or Disable CPU Ratio Override; <b>0: Disable</b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       CpuRatioOverride;

/** Offset 0x0325 - CPU ratio value
  CPU ratio value. Valid Range 0 to 63
**/
  UINT8                       CpuRatio;

/** Offset 0x0326 - Boot frequency
  Sets the boot frequency starting from reset vector.- 0: Maximum battery performance.
  1: Maximum non-turbo performance. <b>2: Turbo performance </b>
  0:0, 1:1, 2:2
**/
  UINT8                       BootFrequency;

/** Offset 0x0327 - Number of active cores
  Number of active cores(Depends on Number of cores). <b>0: All</b>;<b>1: 1 </b>;<b>2:
  2 </b>;<b>3: 3 </b>
  0:All, 1:1, 2:2, 3:3
**/
  UINT8                       ActiveCoreCount;

/** Offset 0x0328 - Processor Early Power On Configuration FCLK setting
  <b>0: 800 MHz (ULT/ULX)</b>. <b>1: 1 GHz (DT/Halo)</b>. Not supported on ULT/ULX.-
  2: 400 MHz. - 3: Reserved
  0:800 MHz, 1: 1 GHz, 2: 400 MHz, 3: Reserved
**/
  UINT8                       FClkFrequency;

/** Offset 0x0329 - Set JTAG power in C10 and deeper power states
  False: JTAG is power gated in C10 state. True: keeps the JTAG power up during C10
  and deeper power states for debug purpose. <b>0: False</b>; 1: True.
  0: False, 1: True
**/
  UINT8                       JtagC10PowerGateDisable;

/** Offset 0x032A - Enable or Disable VMX
  Enable or Disable VMX; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       VmxEnable;

/** Offset 0x032B - AVX2 Ratio Offset
  0(Default)= No Offset. Range 0 - 31. Specifies number of bins to decrease AVX ratio
  vs. Core Ratio. Uses Mailbox MSR 0x150, cmd 0x1B.
**/
  UINT8                       Avx2RatioOffset;

/** Offset 0x032C - AVX3 Ratio Offset
  0(Default)= No Offset. Range 0 - 31. Specifies number of bins to decrease AVX ratio
  vs. Core Ratio. Uses Mailbox MSR 0x150, cmd 0x1B.
**/
  UINT8                       Avx3RatioOffset;

/** Offset 0x032D - BCLK Adaptive Voltage Enable
  When enabled, the CPU V/F curves are aware of BCLK frequency when calculated. </b>0:
  Disable;<b> 1: Enable
  $EN_DIS
**/
  UINT8                       BclkAdaptiveVoltage;

/** Offset 0x032E - core voltage override
  The core voltage override which is applied to the entire range of cpu core frequencies.
  Valid Range 0 to 2000
**/
  UINT16                      CoreVoltageOverride;

/** Offset 0x0330 - Core Turbo voltage Adaptive
  Extra Turbo voltage applied to the cpu core when the cpu is operating in turbo mode.
  Valid Range 0 to 2000
**/
  UINT16                      CoreVoltageAdaptive;

/** Offset 0x0332 - Core Turbo voltage Offset
  The voltage offset applied to the core while operating in turbo mode.Valid Range 0 to 1000
**/
  UINT16                      CoreVoltageOffset;

/** Offset 0x0334 - Core PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
**/
  UINT8                       CorePllVoltageOffset;

/** Offset 0x0335 - Ring Downbin
  Ring Downbin enable/disable. When enabled, CPU will ensure the ring ratio is always
  lower than the core ratio.0: Disable; <b>1: Enable.</b>
  $EN_DIS
**/
  UINT8                       RingDownBin;

/** Offset 0x0336 - Ring voltage mode
  Ring voltage mode; <b>0: Adaptive</b>; 1: Override.
  $EN_DIS
**/
  UINT8                       RingVoltageMode;

/** Offset 0x0337 - TjMax Offset
  TjMax offset.Specified value here is clipped by pCode (125 - TjMax Offset) to support
  TjMax in the range of 62 to 115 deg Celsius. Valid Range 10 - 63
**/
  UINT8                       TjMaxOffset;

/** Offset 0x0338 - Ring voltage override
  The ring voltage override which is applied to the entire range of cpu ring frequencies.
  Valid Range 0 to 2000
**/
  UINT16                      RingVoltageOverride;

/** Offset 0x033A - Ring Turbo voltage Adaptive
  Extra Turbo voltage applied to the cpu ring when the cpu is operating in turbo mode.
  Valid Range 0 to 2000
**/
  UINT16                      RingVoltageAdaptive;

/** Offset 0x033C - Ring Turbo voltage Offset
  The voltage offset applied to the ring while operating in turbo mode. Valid Range 0 to 1000
**/
  UINT16                      RingVoltageOffset;

/** Offset 0x033E - Enable or Disable TME
  Enable or Disable TME; <b>0: Disable<b>; 1: Enable.
  $EN_DIS
**/
  UINT8                       TmeEnable;

/** Offset 0x033F - Enable CPU CrashLog
  Enable or Disable CPU CrashLog; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       CpuCrashLogEnable;

/** Offset 0x0340 - ElixirSpringsPatchAddr
  DEPRECATED
**/
  UINT32                      ElixirSpringsPatchAddr;

/** Offset 0x0344 - ElixirSpringsPatchSize
  DEPRECATED
**/
  UINT32                      ElixirSpringsPatchSize;

/** Offset 0x0348 - CPU Run Control
  Enable, Disable or Do not configure CPU Run Control; 0: Disable; 1: Enable ; <b>2:
  No Change</b>
  0:Disabled, 1:Enabled, 2:No Change
**/
  UINT8                       DebugInterfaceEnable;

/** Offset 0x0349 - CPU Run Control Lock
  Lock or Unlock CPU Run Control; 0: Disable; <b>1: Enable</b>.
  $EN_DIS
**/
  UINT8                       DebugInterfaceLockEnable;

/** Offset 0x034A - BiosGuard
  Enable/Disable. 0: Disable, Enable/Disable BIOS Guard feature, 1: enable
  $EN_DIS
**/
  UINT8                       BiosGuard;

/** Offset 0x034B
**/
  UINT8                       BiosGuardToolsInterface;

/** Offset 0x034C - EnableSgx
  Enable/Disable. 0: Disable, Enable/Disable SGX feature, 1: enable, 2: Software Control
  0: Disable, 1: Enable, 2: Software Control
**/
  UINT8                       EnableSgx;

/** Offset 0x034D - Txt
  Enable/Disable. 0: Disable, Enable/Disable Txt feature, 1: enable
  $EN_DIS
**/
  UINT8                       Txt;

/** Offset 0x034E
**/
  UINT8                       UnusedUpdSpace10[2];

/** Offset 0x0350 - PrmrrSize
  Enable/Disable. 0: Disable, define default value of PrmrrSize , 1: enable
**/
  UINT32                      PrmrrSize;

/** Offset 0x0354 - SinitMemorySize
  Enable/Disable. 0: Disable, define default value of SinitMemorySize , 1: enable
**/
  UINT32                      SinitMemorySize;

/** Offset 0x0358 - TxtDprMemoryBase
  Enable/Disable. 0: Disable, define default value of TxtDprMemoryBase , 1: enable
**/
  UINT64                      TxtDprMemoryBase;

/** Offset 0x0360 - TxtHeapMemorySize
  Enable/Disable. 0: Disable, define default value of TxtHeapMemorySize , 1: enable
**/
  UINT32                      TxtHeapMemorySize;

/** Offset 0x0364 - TxtDprMemorySize
  Enable/Disable. 0: Disable, define default value of TxtDprMemorySize , 1: enable
**/
  UINT32                      TxtDprMemorySize;

/** Offset 0x0368 - BiosAcmBase
  Enable/Disable. 0: Disable, define default value of BiosAcmBase , 1: enable
**/
  UINT32                      BiosAcmBase;

/** Offset 0x036C - BiosAcmSize
  Enable/Disable. 0: Disable, define default value of BiosAcmSize , 1: enable
**/
  UINT32                      BiosAcmSize;

/** Offset 0x0370 - ApStartupBase
  Enable/Disable. 0: Disable, define default value of BiosAcmBase , 1: enable
**/
  UINT32                      ApStartupBase;

/** Offset 0x0374 - TgaSize
  Enable/Disable. 0: Disable, define default value of TgaSize , 1: enable
**/
  UINT32                      TgaSize;

/** Offset 0x0378 - TxtLcpPdBase
  Enable/Disable. 0: Disable, define default value of TxtLcpPdBase , 1: enable
**/
  UINT64                      TxtLcpPdBase;

/** Offset 0x0380 - TxtLcpPdSize
  Enable/Disable. 0: Disable, define default value of TxtLcpPdSize , 1: enable
**/
  UINT64                      TxtLcpPdSize;

/** Offset 0x0388 - IsTPMPresence
  IsTPMPresence default values
**/
  UINT8                       IsTPMPresence;

/** Offset 0x0389 - Configuration for boot TDP selection
  Configuration for boot TDP selection; <b>0: TDP Nominal</b>; 1: TDP Down; 2: TDP
  Up;0xFF : Deactivate
**/
  UINT8                       ConfigTdpLevel;

/** Offset 0x038A - ReservedSecurityPreMem
  Reserved for Security Pre-Mem
  $EN_DIS
**/
  UINT8                       ReservedSecurityPreMem[5];

/** Offset 0x038F - Enable PCH HSIO PCIE Rx Set Ctle
  Enable PCH PCIe Gen 3 Set CTLE Value.
**/
  UINT8                       PchPcieHsioRxSetCtleEnable[24];

/** Offset 0x03A7 - PCH HSIO PCIE Rx Set Ctle Value
  PCH PCIe Gen 3 Set CTLE Value.
**/
  UINT8                       PchPcieHsioRxSetCtle[24];

/** Offset 0x03BF - Enble PCH HSIO PCIE TX Gen 1 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen1DownscaleAmpEnable[24];

/** Offset 0x03D7 - PCH HSIO PCIE Gen 2 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 2 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen1DownscaleAmp[24];

/** Offset 0x03EF - Enable PCH HSIO PCIE TX Gen 2 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DownscaleAmpEnable[24];

/** Offset 0x0407 - PCH HSIO PCIE Gen 2 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 2 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen2DownscaleAmp[24];

/** Offset 0x041F - Enable PCH HSIO PCIE TX Gen 3 Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen3DownscaleAmpEnable[24];

/** Offset 0x0437 - PCH HSIO PCIE Gen 3 TX Output Downscale Amplitude Adjustment value
  PCH PCIe Gen 3 TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchPcieHsioTxGen3DownscaleAmp[24];

/** Offset 0x044F - Enable PCH HSIO PCIE Gen 1 TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen1DeEmphEnable[24];

/** Offset 0x0467 - PCH HSIO PCIE Gen 1 TX Output De-Emphasis Adjustment value
  PCH PCIe Gen 1 TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen1DeEmph[24];

/** Offset 0x047F - Enable PCH HSIO PCIE Gen 2 TX Output -3.5dB De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph3p5Enable[24];

/** Offset 0x0497 - PCH HSIO PCIE Gen 2 TX Output -3.5dB De-Emphasis Adjustment value
  PCH PCIe Gen 2 TX Output -3.5dB De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph3p5[24];

/** Offset 0x04AF - Enable PCH HSIO PCIE Gen 2 TX Output -6.0dB De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph6p0Enable[24];

/** Offset 0x04C7 - PCH HSIO PCIE Gen 2 TX Output -6.0dB De-Emphasis Adjustment value
  PCH PCIe Gen 2 TX Output -6.0dB De-Emphasis Adjustment Setting.
**/
  UINT8                       PchPcieHsioTxGen2DeEmph6p0[24];

/** Offset 0x04DF - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen1EqBoostMagEnable[8];

/** Offset 0x04E7 - PCH HSIO SATA 1.5 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 1.5 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen1EqBoostMag[8];

/** Offset 0x04EF - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen2EqBoostMagEnable[8];

/** Offset 0x04F7 - PCH HSIO SATA 3.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 3.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen2EqBoostMag[8];

/** Offset 0x04FF - Enable PCH HSIO SATA Receiver Equalization Boost Magnitude Adjustment Value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioRxGen3EqBoostMagEnable[8];

/** Offset 0x0507 - PCH HSIO SATA 6.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value
  PCH HSIO SATA 6.0 Gb/s Receiver Equalization Boost Magnitude Adjustment value.
**/
  UINT8                       PchSataHsioRxGen3EqBoostMag[8];

/** Offset 0x050F - Enable PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen1DownscaleAmpEnable[8];

/** Offset 0x0517 - PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 1.5 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen1DownscaleAmp[8];

/** Offset 0x051F - Enable PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen2DownscaleAmpEnable[8];

/** Offset 0x0527 - PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 3.0 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen2DownscaleAmp[8];

/** Offset 0x052F - Enable PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen3DownscaleAmpEnable[8];

/** Offset 0x0537 - PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value
  PCH HSIO SATA 6.0 Gb/s TX Output Downscale Amplitude Adjustment value.
**/
  UINT8                       PchSataHsioTxGen3DownscaleAmp[8];

/** Offset 0x053F - Enable PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen1DeEmphEnable[8];

/** Offset 0x0547 - PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 1.5 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen1DeEmph[8];

/** Offset 0x054F - Enable PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen2DeEmphEnable[8];

/** Offset 0x0557 - PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 3.0 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen2DeEmph[8];

/** Offset 0x055F - Enable PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting value override
  0: Disable; 1: Enable.
**/
  UINT8                       PchSataHsioTxGen3DeEmphEnable[8];

/** Offset 0x0567 - PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting
  PCH HSIO SATA 6.0 Gb/s TX Output De-Emphasis Adjustment Setting.
**/
  UINT8                       PchSataHsioTxGen3DeEmph[8];

/** Offset 0x056F - PCH LPC Enhanced Port 80 Decoding
  Original LPC only decodes one byte of port 80h.
  $EN_DIS
**/
  UINT8                       PchLpcEnhancePort8xhDecoding;

/** Offset 0x0570 - PCH Port80 Route
  Control where the Port 80h cycles are sent, 0: LPC; 1: PCI.
  0:LPC, 1:PCI
**/
  UINT8                       PchPort80Route;

/** Offset 0x0571 - Enable SMBus ARP support
  Enable SMBus ARP support.
  $EN_DIS
**/
  UINT8                       SmbusArpEnable;

/** Offset 0x0572 - Number of RsvdSmbusAddressTable.
  The number of elements in the RsvdSmbusAddressTable.
**/
  UINT8                       PchNumRsvdSmbusAddresses;

/** Offset 0x0573
**/
  UINT8                       UnusedUpdSpace11;

/** Offset 0x0574 - SMBUS Base Address
  SMBUS Base Address (IO space).
**/
  UINT16                      PchSmbusIoBase;

/** Offset 0x0576 - Enable SMBus Alert Pin
  Enable SMBus Alert Pin.
  $EN_DIS
**/
  UINT8                       PchSmbAlertEnable;

/** Offset 0x0577 - Usage type for ClkSrc
  0-23: PCH rootport, 0x40-0x43: PEG port, 0x70:LAN, 0x80: unspecified but in use
  (free running), 0xFF: not used
**/
  UINT8                       PcieClkSrcUsage[16];

/** Offset 0x0587 - ClkReq-to-ClkSrc mapping
  Number of ClkReq signal assigned to ClkSrc
**/
  UINT8                       PcieClkSrcClkReq[16];

/** Offset 0x0597
**/
  UINT8                       UnusedUpdSpace12;

/** Offset 0x0598 - Point of RsvdSmbusAddressTable
  Array of addresses reserved for non-ARP-capable SMBus devices.
**/
  UINT32                      RsvdSmbusAddressTablePtr;

/** Offset 0x059C - Enable PCIE RP Mask
  Enable/disable PCIE Root Ports. 0: disable, 1: enable. One bit for each port, bit0
  for port1, bit1 for port2, and so on.
**/
  UINT32                      PcieRpEnableMask;

/** Offset 0x05A0 - Debug Interfaces
  Debug Interfaces. BIT0-RAM, BIT1-UART, BIT3-USB3, BIT4-Serial IO, BIT5-TraceHub,
  BIT2 - Not used.
**/
  UINT8                       PcdDebugInterfaceFlags;

/** Offset 0x05A1 - Serial Io Uart Debug Controller Number
  Select SerialIo Uart Controller for debug. Note: If UART0 is selected as CNVi BT
  Core interface, it cannot be used for debug purpose.
  0:SerialIoUart0, 1:SerialIoUart1, 2:SerialIoUart2
**/
  UINT8                       SerialIoUartDebugControllerNumber;

/** Offset 0x05A2 - Serial Io Uart Debug Auto Flow
  Enables UART hardware flow control, CTS and RTS lines.
  $EN_DIS
**/
  UINT8                       SerialIoUartDebugAutoFlow;

/** Offset 0x05A3
**/
  UINT8                       UnusedUpdSpace13;

/** Offset 0x05A4 - Serial Io Uart Debug BaudRate
  Set default BaudRate Supported from 0 - default to 6000000. Recommended values 9600,
  19200, 57600, 115200, 460800, 921600, 1500000, 1843200, 3000000, 3686400, 6000000
**/
  UINT32                      SerialIoUartDebugBaudRate;

/** Offset 0x05A8 - Serial Io Uart Debug Parity
  Set default Parity.
  0: DefaultParity, 1: NoParity, 2: EvenParity, 3: OddParity
**/
  UINT8                       SerialIoUartDebugParity;

/** Offset 0x05A9 - Serial Io Uart Debug Stop Bits
  Set default stop bits.
  0: DefaultStopBits, 1: OneStopBit, 2: OneFiveStopBits, 3: TwoStopBits
**/
  UINT8                       SerialIoUartDebugStopBits;

/** Offset 0x05AA - Serial Io Uart Debug Data Bits
  Set default word length. 0: Default, 5,6,7,8
  5:5BITS, 6:6BITS, 7:7BITS, 8:8BITS
**/
  UINT8                       SerialIoUartDebugDataBits;

/** Offset 0x05AB
**/
  UINT8                       UnusedUpdSpace14;

/** Offset 0x05AC - Serial Io Uart Debug Mmio Base
  Select SerialIo Uart default MMIO resource in SEC/PEI phase when PcdSerialIoUartMode
  = SerialIoUartPci.
**/
  UINT32                      SerialIoUartDebugMmioBase;

/** Offset 0x05B0 - ISA Serial Base selection
  Select ISA Serial Base address. Default is 0x3F8.
  0:0x3F8, 1:0x2F8
**/
  UINT8                       PcdIsaSerialUartBase;

/** Offset 0x05B1 - GT PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
**/
  UINT8                       GtPllVoltageOffset;

/** Offset 0x05B2 - Ring PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
**/
  UINT8                       RingPllVoltageOffset;

/** Offset 0x05B3 - System Agent PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
**/
  UINT8                       SaPllVoltageOffset;

/** Offset 0x05B4 - Memory Controller PLL voltage offset
  Core PLL voltage offset. <b>0: No offset</b>. Range 0-63
**/
  UINT8                       McPllVoltageOffset;

/** Offset 0x05B5 - MRC Safe Config
  Enables/Disable MRC Safe Config
  $EN_DIS
**/
  UINT8                       MrcSafeConfig;

/** Offset 0x05B6 - TCSS Thunderbolt PCIE Root Port 0 Enable
  Set TCSS Thunderbolt PCIE Root Port 0. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssItbtPcie0En;

/** Offset 0x05B7 - TCSS Thunderbolt PCIE Root Port 1 Enable
  Set TCSS Thunderbolt PCIE Root Port 1. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssItbtPcie1En;

/** Offset 0x05B8 - TCSS Thunderbolt PCIE Root Port 2 Enable
  Set TCSS Thunderbolt PCIE Root Port 2. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssItbtPcie2En;

/** Offset 0x05B9 - TCSS Thunderbolt PCIE Root Port 3 Enable
  Set TCSS Thunderbolt PCIE Root Port 3. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssItbtPcie3En;

/** Offset 0x05BA - TCSS USB HOST (xHCI) Enable
  Set TCSS XHCI. 0:Disabled  1:Enabled - Must be enabled if xDCI is enabled below
  $EN_DIS
**/
  UINT8                       TcssXhciEn;

/** Offset 0x05BB - TCSS USB DEVICE (xDCI) Enable
  Set TCSS XDCI. 0:Disabled  1:Enabled - xHCI must be enabled if xDCI is enabled
  $EN_DIS
**/
  UINT8                       TcssXdciEn;

/** Offset 0x05BC - TCSS DMA0 Enable
  Set TCSS DMA0. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssDma0En;

/** Offset 0x05BD - TCSS DMA1 Enable
  Set TCSS DMA1. 0:Disabled  1:Enabled
  $EN_DIS
**/
  UINT8                       TcssDma1En;

/** Offset 0x05BE - PcdSerialDebugBaudRate
  Baud Rate for Serial Debug Messages. 3:9600, 4:19200, 6:56700, 7:115200.
  3:9600, 4:19200, 6:56700, 7:115200
**/
  UINT8                       PcdSerialDebugBaudRate;

/** Offset 0x05BF - HobBufferSize
  Size to set HOB Buffer. 0:Default, 1: 1 Byte, 2: 1 KB, 3: Max value(assuming 63KB
  total HOB size).
  0:Default, 1: 1 Byte, 2: 1 KB, 3: Max value
**/
  UINT8                       HobBufferSize;

/** Offset 0x05C0 - Early Command Training
  Enables/Disable Early Command Training
  $EN_DIS
**/
  UINT8                       ECT;

/** Offset 0x05C1 - SenseAmp Offset Training
  Enables/Disable SenseAmp Offset Training
  $EN_DIS
**/
  UINT8                       SOT;

/** Offset 0x05C2 - Early ReadMPR Timing Centering 2D
  Enables/Disable Early ReadMPR Timing Centering 2D
  $EN_DIS
**/
  UINT8                       ERDMPRTC2D;

/** Offset 0x05C3 - Read MPR Training
  Enables/Disable Read MPR Training
  $EN_DIS
**/
  UINT8                       RDMPRT;

/** Offset 0x05C4 - Receive Enable Training
  Enables/Disable Receive Enable Training
  $EN_DIS
**/
  UINT8                       RCVET;

/** Offset 0x05C5 - Jedec Write Leveling
  Enables/Disable Jedec Write Leveling
  $EN_DIS
**/
  UINT8                       JWRL;

/** Offset 0x05C6 - Early Write Time Centering 2D
  Enables/Disable Early Write Time Centering 2D
  $EN_DIS
**/
  UINT8                       EWRTC2D;

/** Offset 0x05C7 - Early Read Time Centering 2D
  Enables/Disable Early Read Time Centering 2D
  $EN_DIS
**/
  UINT8                       ERDTC2D;

/** Offset 0x05C8 - Write Timing Centering 1D
  Enables/Disable Write Timing Centering 1D
  $EN_DIS
**/
  UINT8                       WRTC1D;

/** Offset 0x05C9 - Write Voltage Centering 1D
  Enables/Disable Write Voltage Centering 1D
  $EN_DIS
**/
  UINT8                       WRVC1D;

/** Offset 0x05CA - Read Timing Centering 1D
  Enables/Disable Read Timing Centering 1D
  $EN_DIS
**/
  UINT8                       RDTC1D;

/** Offset 0x05CB - Dimm ODT Training
  Enables/Disable Dimm ODT Training
  $EN_DIS
**/
  UINT8                       DIMMODTT;

/** Offset 0x05CC - DIMM RON Training
  Enables/Disable DIMM RON Training
  $EN_DIS
**/
  UINT8                       DIMMRONT;

/** Offset 0x05CD - Write Drive Strength/Equalization 2D
  Enables/Disable Write Drive Strength/Equalization 2D
  $EN_DIS
**/
  UINT8                       WRDSEQT;

/** Offset 0x05CE - Write Slew Rate Training
  Enables/Disable Write Slew Rate Training
  $EN_DIS
**/
  UINT8                       WRSRT;

/** Offset 0x05CF - Read ODT Training
  Enables/Disable Read ODT Training
  $EN_DIS
**/
  UINT8                       RDODTT;

/** Offset 0x05D0 - Read Equalization Training
  Enables/Disable Read Equalization Training
  $EN_DIS
**/
  UINT8                       RDEQT;

/** Offset 0x05D1 - Read Amplifier Training
  Enables/Disable Read Amplifier Training
  $EN_DIS
**/
  UINT8                       RDAPT;

/** Offset 0x05D2 - Write Timing Centering 2D
  Enables/Disable Write Timing Centering 2D
  $EN_DIS
**/
  UINT8                       WRTC2D;

/** Offset 0x05D3 - Read Timing Centering 2D
  Enables/Disable Read Timing Centering 2D
  $EN_DIS
**/
  UINT8                       RDTC2D;

/** Offset 0x05D4 - Write Voltage Centering 2D
  Enables/Disable Write Voltage Centering 2D
  $EN_DIS
**/
  UINT8                       WRVC2D;

/** Offset 0x05D5 - Read Voltage Centering 2D
  Enables/Disable Read Voltage Centering 2D
  $EN_DIS
**/
  UINT8                       RDVC2D;

/** Offset 0x05D6 - Command Voltage Centering
  Enables/Disable Command Voltage Centering
  $EN_DIS
**/
  UINT8                       CMDVC;

/** Offset 0x05D7 - Late Command Training
  Enables/Disable Late Command Training
  $EN_DIS
**/
  UINT8                       LCT;

/** Offset 0x05D8 - Round Trip Latency Training
  Enables/Disable Round Trip Latency Training
  $EN_DIS
**/
  UINT8                       RTL;

/** Offset 0x05D9 - Turn Around Timing Training
  Enables/Disable Turn Around Timing Training
  $EN_DIS
**/
  UINT8                       TAT;

/** Offset 0x05DA - Memory Test
  Enables/Disable Memory Test
  $EN_DIS
**/
  UINT8                       MEMTST;

/** Offset 0x05DB - DIMM SPD Alias Test
  Enables/Disable DIMM SPD Alias Test
  $EN_DIS
**/
  UINT8                       ALIASCHK;

/** Offset 0x05DC - Receive Enable Centering 1D
  Enables/Disable Receive Enable Centering 1D
  $EN_DIS
**/
  UINT8                       RCVENC1D;

/** Offset 0x05DD - Retrain Margin Check
  Enables/Disable Retrain Margin Check
  $EN_DIS
**/
  UINT8                       RMC;

/** Offset 0x05DE - Write Drive Strength Up/Dn independently
  Enables/Disable Write Drive Strength Up/Dn independently
  $EN_DIS
**/
  UINT8                       WRDSUDT;

/** Offset 0x05DF - ECC Support
  Enables/Disable ECC Support
  $EN_DIS
**/
  UINT8                       EccSupport;

/** Offset 0x05E0 - Ibecc
  In-Band ECC Support
  $EN_DIS
**/
  UINT8                       Ibecc;

/** Offset 0x05E1 - IbeccParity
  In-Band ECC Parity Control
  $EN_DIS
**/
  UINT8                       IbeccParity;

/** Offset 0x05E2 - IbeccOperationMode
  In-Band ECC Operation Mode
  0:Protect base on address range, 1: Non-protected, 2: All protected
**/
  UINT8                       IbeccOperationMode;

/** Offset 0x05E3 - IbeccProtectedRegionEnable
  In-Band ECC Protected Region Enable
  $EN_DIS
**/
  UINT8                       IbeccProtectedRegionEnable[8];

/** Offset 0x05EB
**/
  UINT8                       UnusedUpdSpace15[1];

/** Offset 0x05EC - IbeccProtectedRegionBases
  IBECC Protected Region Bases
**/
  UINT16                      IbeccProtectedRegionBase[8];

/** Offset 0x05FC - IbeccProtectedRegionMasks
  IBECC Protected Region Masks
**/
  UINT16                      IbeccProtectedRegionMask[8];

/** Offset 0x060C - Memory Remap
  Enables/Disable Memory Remap
  $EN_DIS
**/
  UINT8                       RemapEnable;

/** Offset 0x060D - Rank Interleave support
  Enables/Disable Rank Interleave support. NOTE: RI and HORI can not be enabled at
  the same time.
  $EN_DIS
**/
  UINT8                       RankInterleave;

/** Offset 0x060E - Enhanced Interleave support
  Enables/Disable Enhanced Interleave support
  $EN_DIS
**/
  UINT8                       EnhancedInterleave;

/** Offset 0x060F - Ch Hash Support
  Enable/Disable Channel Hash Support. NOTE: ONLY if Memory interleaved Mode
  $EN_DIS
**/
  UINT8                       ChHashEnable;

/** Offset 0x0610 - Extern Therm Status
  Enables/Disable Extern Therm Status
  $EN_DIS
**/
  UINT8                       EnableExtts;

/** Offset 0x0611 - DDR PowerDown and idle counter
  Enables/Disable DDR PowerDown and idle counter(For LPDDR Only)
  $EN_DIS
**/
  UINT8                       EnablePwrDn;

/** Offset 0x0612 - DDR PowerDown and idle counter
  Enables/Disable DDR PowerDown and idle counter(For LPDDR Only)
  $EN_DIS
**/
  UINT8                       EnablePwrDnLpddr;

/** Offset 0x0613 - SelfRefresh Enable
  Enables/Disable SelfRefresh Enable
  $EN_DIS
**/
  UINT8                       SrefCfgEna;

/** Offset 0x0614 - Throttler CKEMin Defeature
  Enables/Disable Throttler CKEMin Defeature(For LPDDR Only)
  $EN_DIS
**/
  UINT8                       ThrtCkeMinDefeatLpddr;

/** Offset 0x0615 - Throttler CKEMin Defeature
  Enables/Disable Throttler CKEMin Defeature
  $EN_DIS
**/
  UINT8                       ThrtCkeMinDefeat;

/** Offset 0x0616 - Enable RH Prevention
  Enables/Disable RH Prevention
  $EN_DIS
**/
  UINT8                       RhPrevention;

/** Offset 0x0617 - Exit On Failure (MRC)
  Enables/Disable Exit On Failure (MRC)
  $EN_DIS
**/
  UINT8                       ExitOnFailure;

/** Offset 0x0618 - New Features 1 - MRC
  New Feature Enabling 1, <b>0:Disable</b>, 1:Enable
  0:Disable, 1:Enable
**/
  UINT8                       NewFeatureEnable1;

/** Offset 0x0619 - New Features 2 - MRC
  New Feature Enabling 2, <b>0:Disable</b>, 1:Enable
  0:Disable, 1:Enable
**/
  UINT8                       NewFeatureEnable2;

/** Offset 0x061A - Duty Cycle Correction Training
  Enable/Disable Duty Cycle Correction Training
  $EN_DIS
**/
  UINT8                       DCC;

/** Offset 0x061B - Read Voltage Centering 1D
  Enable/Disable Read Voltage Centering 1D
  $EN_DIS
**/
  UINT8                       RDVC1D;

/** Offset 0x061C - TxDqTCO Comp Training
  Enable/Disable TxDqTCO Comp Training
  $EN_DIS
**/
  UINT8                       TXTCO;

/** Offset 0x061D - ClkTCO Comp Training
  Enable/Disable ClkTCO Comp Training
  $EN_DIS
**/
  UINT8                       CLKTCO;

/** Offset 0x061E - CMD Slew Rate Training
  Enable/Disable CMD Slew Rate Training
  $EN_DIS
**/
  UINT8                       CMDSR;

/** Offset 0x061F - CMD Drive Strength and Tx Equalization
  Enable/Disable CMD Drive Strength and Tx Equalization
  $EN_DIS
**/
  UINT8                       CMDDSEQ;

/** Offset 0x0620 - DIMM CA ODT Training
  Enable/Disable DIMM CA ODT Training
  $EN_DIS
**/
  UINT8                       DIMMODTCA;

/** Offset 0x0621 - TxDqsTCO Comp Training
  Enable/Disable TxDqsTCO Comp Training
  $EN_DIS
**/
  UINT8                       TXTCODQS;

/** Offset 0x0622 - CMD/CTL Drive Strength Up/Dn 2D
  Enable/Disable CMD/CTL Drive Strength Up/Dn 2D
  $EN_DIS
**/
  UINT8                       CMDDRUD;

/** Offset 0x0623 - VccDLL Bypass Training
  Enable/Disable VccDLL Bypass Training
  $EN_DIS
**/
  UINT8                       VCCDLLBP;

/** Offset 0x0624 - PanicVttDnLp Training
  Enable/Disable PanicVttDnLp Training
  $EN_DIS
**/
  UINT8                       PVTTDNLP;

/** Offset 0x0625 - Read Vref Decap Training*
  Enable/Disable Read Vref Decap Training*
  $EN_DIS
**/
  UINT8                       RDVREFDC;

/** Offset 0x0626 - Vddq Training
  Enable/Disable Vddq Training
  $EN_DIS
**/
  UINT8                       VDDQT;

/** Offset 0x0627 - Rank Margin Tool Per Bit
  Enable/Disable Rank Margin Tool Per Bit
  $EN_DIS
**/
  UINT8                       RMTBIT;

/** Offset 0x0628 -  Override Performance Downgrade for Mixed Memory
  Disable/Enables Override Performance Downgrade for Mixed Memory
  $EN_DIS
**/
  UINT8                       OverrideDowngradeForMixedMemory;

/** Offset 0x0629
**/
  UINT8                       Reserved2[1];

/** Offset 0x062A - Select if CLK0 is shared between Rank0 and Rank1 in DDR4 DDP
  Select if CLK0 is shared between Rank0 and Rank1 in DDR4 DDP
  $EN_DIS
**/
  UINT8                       Ddr4DdpSharedClock;

/** Offset 0x062B - Select if ZQ pin is shared between Rank0 and Rank1 in DDR4 DDP
  ESelect if ZQ pin is shared between Rank0 and Rank1 in DDR4 DDP
  $EN_DIS
**/
  UINT8                       Ddr4DdpSharedZq;

/** Offset 0x062C - Ch Hash Interleaved Bit
  Select the BIT to be used for Channel Interleaved mode. NOTE: BIT7 will interlave
  the channels at a 2 cacheline granularity, BIT8 at 4 and BIT9 at 8. Default is BIT8
  0:BIT6, 1:BIT7, 2:BIT8, 3:BIT9, 4:BIT10, 5:BIT11, 6:BIT12, 7:BIT13
**/
  UINT8                       ChHashInterleaveBit;

/** Offset 0x062D
**/
  UINT8                       UnusedUpdSpace16;

/** Offset 0x062E - Ch Hash Mask
  Set the BIT(s) to be included in the XOR function. NOTE BIT mask corresponds to
  BITS [19:6] Default is 0x0830
**/
  UINT16                      ChHashMask;

/** Offset 0x0630 - Base reference clock value
  Base reference clock value, in Hertz(Default is 100Hz)
  100000000:100Hz, 125000000:125Hz, 167000000:167Hz, 250000000:250Hz
**/
  UINT32                      BClkFrequency;

/** Offset 0x0634 - EPG DIMM Idd3N
  Active standby current (Idd3N) in milliamps from datasheet. Must be calculated on
  a per DIMM basis. Default is 26
**/
  UINT16                      Idd3n;

/** Offset 0x0636 - EPG DIMM Idd3P
  Active power-down current (Idd3P) in milliamps from datasheet. Must be calculated
  on a per DIMM basis. Default is 11
**/
  UINT16                      Idd3p;

/** Offset 0x0638 - RH Activation Probability
  RH Activation Probability, Probability value is 1/2^(inputvalue)
**/
  UINT8                       RhActProbability;

/** Offset 0x0639 - Idle Energy Mc0Ch0Dimm0
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc0Ch0Dimm0;

/** Offset 0x063A - Idle Energy Mc0Ch0Dimm1
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc0Ch0Dimm1;

/** Offset 0x063B - Idle Energy Mc0Ch1Dimm0
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc0Ch1Dimm0;

/** Offset 0x063C - Idle Energy Mc0Ch1Dimm1
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc0Ch1Dimm1;

/** Offset 0x063D - Idle Energy Mc1Ch0Dimm0
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc1Ch0Dimm0;

/** Offset 0x063E - Idle Energy Mc1Ch0Dimm1
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc1Ch0Dimm1;

/** Offset 0x063F - Idle Energy Mc1Ch1Dimm0
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc1Ch1Dimm0;

/** Offset 0x0640 - Idle Energy Mc1Ch1Dimm1
  Idle Energy Consumed for 1 clk w/dimm idle/cke on, range[63;0],(10= Def)
**/
  UINT8                       IdleEnergyMc1Ch1Dimm1;

/** Offset 0x0641 - PowerDown Energy Mc0Ch0Dimm0
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc0Ch0Dimm0;

/** Offset 0x0642 - PowerDown Energy Mc0Ch0Dimm1
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc0Ch0Dimm1;

/** Offset 0x0643 - PowerDown Energy Mc0Ch1Dimm0
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc0Ch1Dimm0;

/** Offset 0x0644 - PowerDown Energy Mc0Ch1Dimm1
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc0Ch1Dimm1;

/** Offset 0x0645 - PowerDown Energy Mc1Ch0Dimm0
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc1Ch0Dimm0;

/** Offset 0x0646 - PowerDown Energy Mc1Ch0Dimm1
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc1Ch0Dimm1;

/** Offset 0x0647 - PowerDown Energy Mc1Ch1Dimm0
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc1Ch1Dimm0;

/** Offset 0x0648 - PowerDown Energy Mc1Ch1Dimm1
  PowerDown Energy Consumed w/dimm idle/cke off, range[63;0],(6= Def)
**/
  UINT8                       PdEnergyMc1Ch1Dimm1;

/** Offset 0x0649 - Activate Energy Mc0Ch0Dimm0
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc0Ch0Dimm0;

/** Offset 0x064A - Activate Energy Mc0Ch0Dimm1
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc0Ch0Dimm1;

/** Offset 0x064B - Activate Energy Mc0Ch1Dimm0
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc0Ch1Dimm0;

/** Offset 0x064C - Activate Energy Mc0Ch1Dimm1
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc0Ch1Dimm1;

/** Offset 0x064D - Activate Energy Mc1Ch0Dimm0
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc1Ch0Dimm0;

/** Offset 0x064E - Activate Energy Mc1Ch0Dimm1
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc1Ch0Dimm1;

/** Offset 0x064F - Activate Energy Mc1Ch1Dimm0
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc1Ch1Dimm0;

/** Offset 0x0650 - Activate Energy Mc1Ch1Dimm1
  Activate Energy Contribution, range[255;0],(172= Def)
**/
  UINT8                       ActEnergyMc1Ch1Dimm1;

/** Offset 0x0651 - Read Energy Mc0Ch0Dimm0
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc0Ch0Dimm0;

/** Offset 0x0652 - Read Energy Mc0Ch0Dimm1
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc0Ch0Dimm1;

/** Offset 0x0653 - Read Energy Mc0Ch1Dimm0
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc0Ch1Dimm0;

/** Offset 0x0654 - Read Energy Mc0Ch1Dimm1
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc0Ch1Dimm1;

/** Offset 0x0655 - Read Energy Mc1Ch0Dimm0
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc1Ch0Dimm0;

/** Offset 0x0656 - Read Energy Mc1Ch0Dimm1
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc1Ch0Dimm1;

/** Offset 0x0657 - Read Energy Mc1Ch1Dimm0
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc1Ch1Dimm0;

/** Offset 0x0658 - Read Energy Mc1Ch1Dimm1
  Read Energy Contribution, range[255;0],(212= Def)
**/
  UINT8                       RdEnergyMc1Ch1Dimm1;

/** Offset 0x0659 - Write Energy Mc0Ch0Dimm0
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc0Ch0Dimm0;

/** Offset 0x065A - Write Energy Mc0Ch0Dimm1
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc0Ch0Dimm1;

/** Offset 0x065B - Write Energy Mc0Ch1Dimm0
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc0Ch1Dimm0;

/** Offset 0x065C - Write Energy Mc0Ch1Dimm1
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc0Ch1Dimm1;

/** Offset 0x065D - Write Energy Mc1Ch0Dimm0
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc1Ch0Dimm0;

/** Offset 0x065E - Write Energy Mc1Ch0Dimm1
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc1Ch0Dimm1;

/** Offset 0x065F - Write Energy Mc1Ch1Dimm0
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc1Ch1Dimm0;

/** Offset 0x0660 - Write Energy Mc1Ch1Dimm1
  Write Energy Contribution, range[255;0],(221= Def)
**/
  UINT8                       WrEnergyMc1Ch1Dimm1;

/** Offset 0x0661 - Throttler CKEMin Timer
  Timer value for CKEMin, range[255;0]. Req'd min of SC_ROUND_T + BYTE_LENGTH (4).
  Dfault is 0x00
**/
  UINT8                       ThrtCkeMinTmr;

/** Offset 0x0662 - Rapl Power Floor Ch0
  Power budget ,range[255;0],(0= 5.3W Def)
**/
  UINT8                       RaplPwrFlCh0;

/** Offset 0x0663 - Rapl Power Floor Ch1
  Power budget ,range[255;0],(0= 5.3W Def)
**/
  UINT8                       RaplPwrFlCh1;

/** Offset 0x0664 - Command Rate Support
  CMD Rate and Limit Support Option. NOTE: ONLY supported in 1N Mode, Default is 3 CMDs
  0:Disable, 5:2 CMDS, 7:3 CMDS, 9:4 CMDS, 11:5 CMDS, 13:6 CMDS, 15:7 CMDS
**/
  UINT8                       EnCmdRate;

/** Offset 0x0665 - REFRESH_2X_MODE
  0- (Default)Disabled 1-iMC enables 2xRef when Warm and Hot 2- iMC enables 2xRef when Hot
  0:Disable, 1:Enabled for WARM or HOT, 2:Enabled HOT only
**/
  UINT8                       Refresh2X;

/** Offset 0x0666 - Energy Performance Gain
  Enable/disable(default) Energy Performance Gain.
  $EN_DIS
**/
  UINT8                       EpgEnable;

/** Offset 0x0667 - Row Hammer Solution
  Type of method used to prevent Row Hammer. Default is Hardware RHP
  0:Hardware RHP, 1:2x Refresh
**/
  UINT8                       RhSolution;

/** Offset 0x0668 - User Manual Threshold
  Disabled: Predefined threshold will be used.\n
  Enabled: User Input will be used.
  $EN_DIS
**/
  UINT8                       UserThresholdEnable;

/** Offset 0x0669 - User Manual Budget
  Disabled: Configuration of memories will defined the Budget value.\n
  Enabled: User Input will be used.
  $EN_DIS
**/
  UINT8                       UserBudgetEnable;

/** Offset 0x066A - Power Down Mode
  This option controls command bus tristating during idle periods
  0x0:No Power Down, 0x1:APD, 0x6:PPD DLL OFF, 0xFF:Auto
**/
  UINT8                       PowerDownMode;

/** Offset 0x066B - Pwr Down Idle Timer
  The minimum value should = to the worst case Roundtrip delay + Burst_Length. 0 means
  AUTO: 64 for ULX/ULT, 128 for DT/Halo
**/
  UINT8                       PwdwnIdleCounter;

/** Offset 0x066C - Page Close Idle Timeout
  This option controls Page Close Idle Timeout
  0:Enabled, 1:Disabled
**/
  UINT8                       DisPgCloseIdleTimeout;

/** Offset 0x066D - Bitmask of ranks that have CA bus terminated
  Offset 225 LPDDR4: Bitmask of ranks that have CA bus terminated. <b>0x01=Default,
  Rank0 is terminating and Rank1 is non-terminating</b>
**/
  UINT8                       CmdRanksTerminated;

/** Offset 0x066E - PcdSerialDebugLevel
  Serial Debug Message Level. 0:Disable, 1:Error Only, 2:Error & Warnings, 3:Load,
  Error, Warnings & Info, 4:Load, Error, Warnings, Info & Event, 5:Load, Error, Warnings,
  Info & Verbose.
  0:Disable, 1:Error Only, 2:Error and Warnings, 3:Load Error Warnings and Info, 4:Load
  Error Warnings and Info & Event, 5:Load Error Warnings Info and Verbose
**/
  UINT8                       PcdSerialDebugLevel;

/** Offset 0x066F - Fivr Faults
  Fivr Faults; 0: Disabled; <b>1: Enabled.</b>
  $EN_DIS
**/
  UINT8                       FivrFaults;

/** Offset 0x0670 - Fivr Efficiency
  Fivr Efficiency Management; 0: Disabled; <b>1: Enabled.</b>
  $EN_DIS
**/
  UINT8                       FivrEfficiency;

/** Offset 0x0671 - Safe Mode Support
  This option configures the varous items in the IO and MC to be more conservative.(def=Disable)
  $EN_DIS
**/
  UINT8                       SafeMode;

/** Offset 0x0672 - Ask MRC to clear memory content
  Ask MRC to clear memory content <b>0: Do not Clear Memory;</b> 1: Clear Memory.
  $EN_DIS
**/
  UINT8                       CleanMemory;

/** Offset 0x0673 - LpDdrDqDqsReTraining
  Enables/Disable LpDdrDqDqsReTraining
  $EN_DIS
**/
  UINT8                       LpDdrDqDqsReTraining;

/** Offset 0x0674 - TCSS USB Port Enable
  Bitmap for per port enabling
**/
  UINT8                       UsbTcPortEnPreMem;

/** Offset 0x0675
**/
  UINT8                       UnusedUpdSpace17;

/** Offset 0x0676 - Post Code Output Port
  This option configures Post Code Output Port
**/
  UINT16                      PostCodeOutputPort;

/** Offset 0x0678 - RMTLoopCount
  Specifies the Loop Count to be used during Rank Margin Tool Testing. 0 - AUTO
**/
  UINT8                       RMTLoopCount;

/** Offset 0x0679 - Enable/Disable SA CRID
  Enable: SA CRID, Disable (Default): SA CRID
  $EN_DIS
**/
  UINT8                       CridEnable;

/** Offset 0x067A - WRC Feature
  Enable/Disable WRC (Write Cache) feature of IOP. When feature is enabled, supports
  IO devices allocating onto the ring and into LLC. WRC is fused on by default.
  $EN_DIS
**/
  UINT8                       WrcFeatureEnable;

/** Offset 0x067B
**/
  UINT8                       UnusedUpdSpace18[1];

/** Offset 0x067C - BCLK RFI Frequency
  Bclk RFI Frequency for each SAGV point in Hz units. 98000000Hz = 98MHz <b>0 - No
  RFI Tuning</b>. Range is 98Mhz-100Mhz.
**/
  UINT32                      BclkRfiFreq[4];

/** Offset 0x068C - Size of PCIe IMR.
  Size of PCIe IMR in megabytes
**/
  UINT16                      PcieImrSize;

/** Offset 0x068E - Enable PCIe IMR
  0: Disable(AUTO), 1: Enable
  $EN_DIS
**/
  UINT8                       PcieImrEnabled;

/** Offset 0x068F - Enable PCIe IMR
  1: PCH PCIE, 2: SA PCIE. If PCIeImrEnabled is TRUE then this will use to select
  the Root port location from PCH PCIe or SA PCIe
  $EN_DIS
**/
  UINT8                       PcieImrRpLocation;

/** Offset 0x0690 - Root port number for IMR.
  Root port number for IMR.If PCieImrRpLocation is PCH PCIe then select root port
  from 0 to 23 and if it is SA PCIe then select root port from 0 to 3
**/
  UINT8                       PcieImrRpSelection;

/** Offset 0x0691 - SerialDebugMrcLevel
  MRC Serial Debug Message Level. 0:Disable, 1:Error Only, 2:Error & Warnings, 3:Load,
  Error, Warnings & Info, 4:Load, Error, Warnings, Info & Event, 5:Load, Error, Warnings,
  Info & Verbose.
  0:Disable, 1:Error Only, 2:Error and Warnings, 3:Load Error Warnings and Info, 4:Load
  Error Warnings and Info & Event, 5:Load Error Warnings Info and Verbose
**/
  UINT8                       SerialDebugMrcLevel;

/** Offset 0x0692 - Mem Boot Mode
  0: BOOT_MODE_1LM(Default), 1: BOOT_MODE_2LM, 2: BOOT_MODE_PROVISION
  0: BOOT_MODE_1LM, 1: BOOT_MODE_2LM, 2: BOOT_MODE_PROVISION
**/
  UINT8                       MemBootMode;

/** Offset 0x0693 - PCIe ASPM programming will happen in relation to the Oprom
  (DEPRECATED)
  0:Disabled, 1:L0, 2:L1, 3:L0L1, 4:Auto
**/
  UINT8                       Peg3Aspm;

/** Offset 0x0694 - MFVC WRR VC Arbitration
  0: DEFAULT_PHASES(Default), 1: PROGRAM_128PHASES
  0: DEFAULT_PHASES, 1: PROGRAM_128PHASES
**/
  UINT8                       MfvcWrrArb;

/** Offset 0x0695 - BZM Support
  1: enable, 0: disable(Default), Enable/disable setting for Boot-time Zero Memory support
  $EN_DIS
**/
  UINT8                       BzmSupport;

/** Offset 0x0696 - VcId_7_0 values
  Select VC ID for arbitration
**/
  UINT8                       VcId_7_0[16];

/** Offset 0x06A6 - Set Hw Parameters enable/disable
  1: enable, 0: disable, Enable/disable setting of HW parameters
  $EN_DIS
**/
  UINT8                       SetHwParameters;

/** Offset 0x06A7
**/
  UINT8                       UnusedUpdSpace19;

/** Offset 0x06A8 - LTR L1.2 Threshold Value
  LTR L1.2 Threshold Value
**/
  UINT16                      Ltr_L1D2_ThVal;

/** Offset 0x06AA - LTR L1.2 Threshold Scale
  LTR L1.2 Threshold Scale
**/
  UINT8                       Ltr_L1D2_ThScale;

/** Offset 0x06AB - system power state
  system power state indicates the platform power state
**/
  UINT8                       SysPwrState;

/** Offset 0x06AC - Media Death Notification Enable/Disable
  1: enable, 0: disable, Enable/disable for Media Death Notification
  $EN_DIS
**/
  UINT8                       MediaDeathNotification;

/** Offset 0x06AD - Health Log Notification Enable/Disable
  1: enable, 0: disable, Enable/disable for Health Log Notification
  $EN_DIS
**/
  UINT8                       HealthLogNotification;

/** Offset 0x06AE - Temp crosses below TempThrottle Notification Enable/Disable
  1: enable, 0: disable, Enable/disable for Temp crosses below TempThrottle Notification
  $EN_DIS
**/
  UINT8                       TempBelowThrottleNotification;

/** Offset 0x06AF - Temp crosses above TempThrottle Notification Enable/Disable
  1: enable, 0: disable, Enable/disable for Temp crosses above TempThrottle Notification
  $EN_DIS
**/
  UINT8                       TempAboveThrottleNotification;

/** Offset 0x06B0 - Missing Commit Bit Notification Enable/Disable
  1: enable, 0: disable, Enable/disable for Missing Commit Bit Notification
  $EN_DIS
**/
  UINT8                       MissingCommitBitNotification;

/** Offset 0x06B1 - NVMeHoldDisableBit
  1: enable, 0: disable, Enable/disable for NVMeHoldDisableBit
  $EN_DIS
**/
  UINT8                       NVMeHoldDisableBit;

/** Offset 0x06B2 - Ddr4OneDpc
  DDR4 1DPC performance feature for 2R DIMMs. Can be enabled on DIMM0 or DIMM1 only,
  or on both (default)
  0: Disabled, 1: Enabled on DIMM0 only, 2: Enabled on DIMM1 only, 3: Enabled
**/
  UINT8                       Ddr4OneDpc;

/** Offset 0x06B3 - Ch Hash Override POR settings
  Enable/Disable Override Channel Hash Support POR values
  $EN_DIS
**/
  UINT8                       ChHashOverride;

/** Offset 0x06B4 - PDA Enumeration
  Enables/Disable PDA Enumeration
  $EN_DIS
**/
  UINT8                       PDA;

/** Offset 0x06B5 - DPin Policy
  Set DPin Policy. Internal Only:All display ports are for internal only. External
  First:All display ports are for external only, if there is no External DP-In presence
  presents then IOM will use all ports internal only
  0: Internal Only, 1: External First
**/
  UINT8                       DpInExternalEn;

/** Offset 0x06B6 - DPin External Ports Number
  Total number of External Gfx DpIn Port present on Board. Currently hardware wise
  max 0x04 DpIn port supported, however DpIn module can handle upto 0x08 DpIn ports
**/
  UINT8                       NumberOfDpInPort;

/** Offset 0x06B7 - DPin External Port Connect Map
  Indicate which Dp-In port connection detected. Each BIT stand for one Dp-In port.
**/
  UINT8                       DpInPortConnectMap;

/** Offset 0x06B8 - Command Pins Mapping
  BitMask where bits [3:0] are Controller 0 Channel [3:0] and bits [7:4] are Controller
  1 Channel [3:0]. 0 = CCC pin mapping is Ascending, 1 = CCC pin mapping is Descending.
**/
  UINT8                       Lp5CccConfig[4];

/** Offset 0x06BC - Command Pins Mirrored
  BitMask where bits [3:0] are Controller 0 Channel [3:0] and bits [7:4] are Controller
  1 Channel [3:0]. 0 = No Command Mirror and 1 = Command Mirror.
**/
  UINT32                      CmdMirror[1];

/** Offset 0x06C0 - CPU BCLK SSC Enable
  Enable/Disable CPU BCLK Spread Spectrum. Default is Enabled.
  $EN_DIS
**/
  UINT8                       CpuBclkSpread;

/** Offset 0x06C1 - McParity
  CMI/MC Parity Control
  $EN_DIS
**/
  UINT8                       McParity;

/** Offset 0x06C2 - Vddq Voltage Override
  # is multiple of 1mV where 0 means Auto.
**/
  UINT16                      VddqVoltageOverride;

/** Offset 0x06C4 - Extended Bank Hashing
  Eanble/Disable ExtendedBankHashing
  $EN_DIS
**/
  UINT8                       ExtendedBankHashing;

/** Offset 0x06C5 - Skip external display device scanning
  Enable: Do not scan for external display device, Disable (Default): Scan external
  display devices
  $EN_DIS
**/
  UINT8                       SkipExtGfxScan;

/** Offset 0x06C6 - Generate BIOS Data ACPI Table
  Enable: Generate BDAT for MRC RMT or SA PCIe data. Disable (Default): Do not generate it
  $EN_DIS
**/
  UINT8                       BdatEnable;

/** Offset 0x06C7 - Detect External Graphics device for LegacyOpROM
  Detect and report if external graphics device only support LegacyOpROM or not (to
  support CSM auto-enable). Enable(Default)=1, Disable=0
  $EN_DIS
**/
  UINT8                       ScanExtGfxForLegacyOpRom;

/** Offset 0x06C8 - Lock PCU Thermal Management registers
  Lock PCU Thermal Management registers. Enable(Default)=1, Disable=0
  $EN_DIS
**/
  UINT8                       LockPTMregs;

/** Offset 0x06C9 - Rsvd
  Disable(0x0)(Default): Normal Operation - RxCTLE adaptive behavior enabled, Enable(0x1):
  Override RxCTLE - Disable RxCTLE adaptive behavior to keep the configured RxCTLE
  peak values unmodified
  $EN_DIS
**/
  UINT8                       PegGen3Rsvd;

/** Offset 0x06CA - Panel Power Enable
  Control for enabling/disabling VDD force bit (Required only for early enabling of
  eDP panel). 0=Disable, 1(Default)=Enable
  $EN_DIS
**/
  UINT8                       PanelPowerEnable;

/** Offset 0x06CB - BdatTestType
  Indicates the type of Memory Training data to populate into the BDAT ACPI table.
  0:RMT per Rank, 1:RMT per Bit, 2:Margin2D
**/
  UINT8                       BdatTestType;

/** Offset 0x06CC - PMR Size
  Size of PMR memory buffer. 0x400000 for normal boot and 0x200000 for S3 boot
**/
  UINT32                      DmaBufferSize;

/** Offset 0x06D0 - VT-d/IOMMU Boot Policy
  BIT0: Enable IOMMU during boot, BIT1: Enable IOMMU when transfer control to OS
**/
  UINT8                       PreBootDmaMask;

/** Offset 0x06D1 - Enable/Disable DMI GEN3 Hardware Eq
  Enable/Disable DMI GEN3 Hardware Eq. Disabled(0x0): Disable Hardware Eq, Enabled(0x1)(Default):
  Enable  EQ Phase1 Static Presets Programming
  $EN_DIS
**/
  UINT8                       DmiHweq;

/** Offset 0x06D2 - Enable/Disable CPU DMI GEN3 Phase 23 Bypass
  CPU DMI GEN3 Phase 23 Bypass. Disabled(0x0)(Default): Disable Phase 23 Bypass, Enabled(0x1):
  Enable  Phase 23 Bypass
  $EN_DIS
**/
  UINT8                       Gen3EqPhase23Bypass;

/** Offset 0x06D3 - Enable/Disable CPU DMI GEN3 Phase 3 Bypass
  CPU DMI GEN3 Phase 3 Bypass. Disabled(0x0)(Default): Disable Phase 3 Bypass, Enabled(0x1):
  Enable  Phase 3 Bypass
  $EN_DIS
**/
  UINT8                       Gen3EqPhase3Bypass;

/** Offset 0x06D4 - Enable/Disable CPU DMI Gen3 EQ Local Transmitter Coefficient Override Enable
  Program Gen3 EQ Local Transmitter Coefficient Override. Disabled(0x0)(Default):
  Disable Local Transmitter Coefficient Override, Enabled(0x1): Enable  Local Transmitter
  Coefficient Override
  $EN_DIS
**/
  UINT8                       Gen3LtcoEnable;

/** Offset 0x06D5 - Enable/Disable CPU DMI Gen3 EQ Remote Transmitter Coefficient/Preset Override Enable
  Program Remote Transmitter Coefficient/Preset Override. Disabled(0x0)(Default):
  Disable Remote Transmitter Coefficient/Preset Override, Enabled(0x1): Enable  Remote
  Transmitter Coefficient/Preset Override
  $EN_DIS
**/
  UINT8                       Gen3RtcoRtpoEnable;

/** Offset 0x06D6 - DMI Gen3 Transmitter Pre-Cursor Coefficient
  Used for programming DMI Gen3 Transmitter Pre-Cursor Coefficient . Range: 0-10,
  2 is default for each lane
**/
  UINT8                       DmiGen3Ltcpre[8];

/** Offset 0x06DE - DMI Gen3 Transmitter Post-Cursor Coefficient
  Used for programming Transmitter Post-Cursor Coefficient. Range: 0-9, 2 is default
  for each lane
**/
  UINT8                       DmiGen3Ltcpo[8];

/** Offset 0x06E6 - PCIE Hw Eq Gen3 CoeffList Cm
  CPU_PCIE_EQ_PARAM. Coefficient C-1.
**/
  UINT8                       CpuDmiHwEqGen3CoeffListCm[8];

/** Offset 0x06EE - PCIE Hw Eq Gen3 CoeffList Cp
  CPU_PCIE_EQ_PARAM. Coefficient C+1.
**/
  UINT8                       CpuDmiHwEqGen3CoeffListCp[8];

/** Offset 0x06F6 - Enable/Disable DMI GEN3 DmiGen3DsPresetEnable
  Enable/Disable DMI GEN3 DmiGen3DsPreset. Auto(0x0)(Default): DmiGen3DsPresetEnable,
  Manual(0x1): Enable DmiGen3DsPresetEnable
  $EN_DIS
**/
  UINT8                       DmiGen3DsPresetEnable;

/** Offset 0x06F7 - DMI Gen3 Root port preset Rx values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-10, 1 is default
  for each lane
**/
  UINT8                       DmiGen3DsPortRxPreset[8];

/** Offset 0x06FF - DMI Gen3 Root port preset Tx values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-10, 7 is default
  for each lane
**/
  UINT8                       DmiGen3DsPortTxPreset[8];

/** Offset 0x0707 - Program DMI GEN3 Extended number of VC
  (DEPRECATED)
**/
  UINT8                       DmiGen3MultiVC;

/** Offset 0x0708 - Enable/Disable DMI GEN3 DmiGen3Vc1Control
  (DEPRECATED)
  $EN_DIS
**/
  UINT8                       DmiGen3Vc1Control;

/** Offset 0x0709 - Enable/Disable DMI GEN3 DmiGen3VcMControl
  (DEPRECATED)
  $EN_DIS
**/
  UINT8                       DmiGen3VcMControl;

/** Offset 0x070A - DMI Secure Register Lock:{Combo
  (DEPRECATED)
  0:Disable, 1:Enable
**/
  UINT8                       DmiSrl;

/** Offset 0x070B - DMI Scramble Enable:{Combo
  (DEPRECATED)
  0:Disable, 1:Enable
**/
  UINT8                       DmiScramble;

/** Offset 0x070C - DMI Max Payload Size:{Combo
  (DEPRECATED)
  0:Auto, 1:128 TLP, 2:256 TLP
**/
  UINT8                       DmiMaxPayload;

/** Offset 0x070D - DPin Dynamic Switch Policy
  Dynamic one-time switch from iGFx to dGFx after boot to OS
  0: Disble, 1: Enable
**/
  UINT8                       DPinDynamicSwitch;

/** Offset 0x070E - Delay before sending commn
  Delay before sending dynamic one-time switch cmd to IOM, ACPI BIOS consumes this
  value and proceed delay when _DSM is invoked: 0=Minimal, 5000=Maximum, default
  is 0 second
**/
  UINT16                      DPinDynamicSwitchDelay0;

/** Offset 0x0710 - Delay before IOM de-assert HPD
  Delay before IOM de-assert HPD, ACPI BIOS passes this value to IOM when sending
  dynamic one-time switch command: 1000=Minimal, 5000=Maximum, default is 1000 = 1 second
**/
  UINT16                      DPinDynamicSwitchDelay1;

/** Offset 0x0712 - SaPreMemTestRsvd
  Reserved for SA Pre-Mem Test
  $EN_DIS
**/
  UINT8                       SaPreMemTestRsvd[28];

/** Offset 0x072E - TotalFlashSize
  Enable/Disable. 0: Disable, define default value of TotalFlashSize , 1: enable
**/
  UINT16                      TotalFlashSize;

/** Offset 0x0730 - BiosSize
  The size of the BIOS region of the IFWI. Used if FspmUpd->FspmConfig.BiosGuard !=
  0. If BiosGuard is enabled, MRC will increase the size of the DPR (DMA Protected
  Range) so that a BIOS Update Script can be stored in the DPR.
**/
  UINT16                      BiosSize;

/** Offset 0x0732 - SecurityTestRsvd
  Reserved for SA Pre-Mem Test
  $EN_DIS
**/
  UINT8                       SecurityTestRsvd[12];

/** Offset 0x073E - Smbus dynamic power gating
  Disable or Enable Smbus dynamic power gating.
  $EN_DIS
**/
  UINT8                       SmbusDynamicPowerGating;

/** Offset 0x073F - Disable and Lock Watch Dog Register
  Set 1 to clear WDT status, then disable and lock WDT registers.
  $EN_DIS
**/
  UINT8                       WdtDisableAndLock;

/** Offset 0x0740 - SMBUS SPD Write Disable
  Set/Clear Smbus SPD Write Disable. 0: leave SPD Write Disable bit; 1: set SPD Write
  Disable bit. For security recommendations, SPD write disable bit must be set.
  $EN_DIS
**/
  UINT8                       SmbusSpdWriteDisable;

/** Offset 0x0741 - VC Type
  Virtual Channel Type Select: 0: VC0, 1: VC1.
  0: VC0, 1: VC1
**/
  UINT8                       PchHdaVcType;

/** Offset 0x0742 - Universal Audio Architecture compliance for DSP enabled system
  0: Not-UAA Compliant (Intel SST driver supported only), 1: UAA Compliant (HDA Inbox
  driver or SST driver supported).
  $EN_DIS
**/
  UINT8                       PchHdaDspUaaCompliance;

/** Offset 0x0743 - Enable HD Audio Link
  Enable/disable HD Audio Link. Muxed with SSP0/SSP1/SNDW1.
  $EN_DIS
**/
  UINT8                       PchHdaAudioLinkHdaEnable;

/** Offset 0x0744 - Enable HDA SDI lanes
  Enable/disable HDA SDI lanes.
**/
  UINT8                       PchHdaSdiEnable[2];

/** Offset 0x0746 - HDA Power/Clock Gating (PGD/CGD)
  Enable/Disable HD Audio Power and Clock Gating(POR: Enable). 0: PLATFORM_POR, 1:
  FORCE_ENABLE, 2: FORCE_DISABLE.
  0: POR, 1: Force Enable, 2: Force Disable
**/
  UINT8                       PchHdaTestPowerClockGating;

/** Offset 0x0747 - Enable HD Audio DMIC_N Link
  Enable/disable HD Audio DMIC1 link. Muxed with SNDW3.
**/
  UINT8                       PchHdaAudioLinkDmicEnable[2];

/** Offset 0x0749
**/
  UINT8                       UnusedUpdSpace20[3];

/** Offset 0x074C - DMIC<N> ClkA Pin Muxing (N - DMIC number)
  Determines DMIC<N> ClkA Pin muxing. See  GPIO_*_MUXING_DMIC<N>_CLKA_*
**/
  UINT32                      PchHdaAudioLinkDmicClkAPinMux[2];

/** Offset 0x0754 - DMIC<N> ClkB Pin Muxing
  Determines DMIC<N> ClkA Pin muxing. See GPIO_*_MUXING_DMIC<N>_CLKB_*
**/
  UINT32                      PchHdaAudioLinkDmicClkBPinMux[2];

/** Offset 0x075C - Enable HD Audio DSP
  Enable/disable HD Audio DSP feature.
  $EN_DIS
**/
  UINT8                       PchHdaDspEnable;

/** Offset 0x075D
**/
  UINT8                       UnusedUpdSpace21[3];

/** Offset 0x0760 - DMIC<N> Data Pin Muxing
  Determines DMIC<N> Data Pin muxing. See GPIO_*_MUXING_DMIC<N>_DATA_*
**/
  UINT32                      PchHdaAudioLinkDmicDataPinMux[2];

/** Offset 0x0768 - Enable HD Audio SSP0 Link
  Enable/disable HD Audio SSP_N/I2S link. Muxed with HDA. N-number 0-5
**/
  UINT8                       PchHdaAudioLinkSspEnable[6];

/** Offset 0x076E - Enable HD Audio SoundWire#N Link
  Enable/disable HD Audio SNDW#N link. Muxed with HDA.
**/
  UINT8                       PchHdaAudioLinkSndwEnable[4];

/** Offset 0x0772 - iDisp-Link Frequency
  iDisp-Link Freq (PCH_HDAUDIO_LINK_FREQUENCY enum): 4: 96MHz, 3: 48MHz.
  4: 96MHz, 3: 48MHz
**/
  UINT8                       PchHdaIDispLinkFrequency;

/** Offset 0x0773 - iDisp-Link T-mode
  iDisp-Link T-Mode (PCH_HDAUDIO_IDISP_TMODE enum): 0: 2T, 2: 4T, 3: 8T(Default), 4: 16T
  0: 2T, 2: 4T, 3: 8T, 4: 16T
**/
  UINT8                       PchHdaIDispLinkTmode;

/** Offset 0x0774 - iDisplay Audio Codec disconnection
  0: Not disconnected, enumerable, 1: Disconnected SDI, not enumerable.
  $EN_DIS
**/
  UINT8                       PchHdaIDispCodecDisconnect;

/** Offset 0x0775 - Force ME DID Init Status
  Test, 0: disable, 1: Success, 2: No Memory in Channels, 3: Memory Init Error, Set
  ME DID init stat value
  $EN_DIS
**/
  UINT8                       DidInitStat;

/** Offset 0x0776 - CPU Replaced Polling Disable
  Test, 0: disable, 1: enable, Setting this option disables CPU replacement polling loop
  $EN_DIS
**/
  UINT8                       DisableCpuReplacedPolling;

/** Offset 0x0777 - ME DID Message
  (DEPRECATED)Test, 0: disable, 1: enable, Enable/Disable ME DID Message (disable
  will prevent the DID message from being sent)
  $EN_DIS
**/
  UINT8                       SendDidMsg;

/** Offset 0x0778 - Check HECI message before send
  Test, 0: disable, 1: enable, Enable/Disable message check.
  $EN_DIS
**/
  UINT8                       DisableMessageCheck;

/** Offset 0x0779 - Skip MBP HOB
  Test, 0: disable, 1: enable, Enable/Disable MOB HOB.
  $EN_DIS
**/
  UINT8                       SkipMbpHob;

/** Offset 0x077A - HECI2 Interface Communication
  Test, 0: disable, 1: enable, Adds or Removes HECI2 Device from PCI space.
  $EN_DIS
**/
  UINT8                       HeciCommunication2;

/** Offset 0x077B - Enable KT device
  Test, 0: disable, 1: enable, Enable or Disable KT device.
  $EN_DIS
**/
  UINT8                       KtDeviceEnable;

/** Offset 0x077C - Hybrid Graphics GPIO information for PEG 1
  Hybrid Graphics GPIO information for PEG 1, for Reset, power and wake GPIOs
**/
  UINT32                      CpuPcie1Rtd3Gpio[24];

/** Offset 0x07DC - Hybrid Graphics GPIO information for PEG 2
  Hybrid Graphics GPIO information for PEG 2, for Reset, power and wake GPIOs
**/
  UINT32                      CpuPcie2Rtd3Gpio[24];

/** Offset 0x083C - Hybrid Graphics GPIO information for PEG 3
  Hybrid Graphics GPIO information for PEG 3, for Reset, power and wake GPIOs
**/
  UINT32                      CpuPcie3Rtd3Gpio[24];

/** Offset 0x089C - Skip CPU replacement check
  Test, 0: disable, 1: enable, Setting this option to skip CPU replacement check
  $EN_DIS
**/
  UINT8                       SkipCpuReplacementCheck;

/** Offset 0x089D - PCI Express Dekel Workaround
  Select the 1 to 9 for Dekel registers endpoint programming: 1=Minimal, 9=Maximum,
  default is 2
**/
  UINT8                       CpuPcieRpDekelSquelchWa;

/** Offset 0x089E - Serial Io Uart Debug Mode
  Select SerialIo Uart Controller mode
  0:SerialIoUartDisabled, 1:SerialIoUartPci, 2:SerialIoUartHidden, 3:SerialIoUartCom,
  4:SerialIoUartSkipInit
**/
  UINT8                       SerialIoUartDebugMode;

/** Offset 0x089F
**/
  UINT8                       UnusedUpdSpace22;

/** Offset 0x08A0 - SerialIoUartDebugRxPinMux - FSPT
  Select RX pin muxing for SerialIo UART used for debug
**/
  UINT32                      SerialIoUartDebugRxPinMux;

/** Offset 0x08A4 - SerialIoUartDebugTxPinMux - FSPM
  Select TX pin muxing for SerialIo UART used for debug
**/
  UINT32                      SerialIoUartDebugTxPinMux;

/** Offset 0x08A8 - SerialIoUartDebugRtsPinMux - FSPM
  Select SerialIo Uart used for debug Rts pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_RTS*
  for possible values.
**/
  UINT32                      SerialIoUartDebugRtsPinMux;

/** Offset 0x08AC - SerialIoUartDebugCtsPinMux - FSPM
  Select SerialIo Uart used for debug Cts pin muxing. Refer to GPIO_*_MUXING_SERIALIO_UARTx_CTS*
  for possible values.
**/
  UINT32                      SerialIoUartDebugCtsPinMux;

/** Offset 0x08B0 - Avx2 Voltage Guardband Scaling Factor
  AVX2 Voltage Guardband Scale factor applied to AVX2 workloads. Range is 0-200 in
  1/100 units, where a value of 125 would apply a 1.25 scale factor.
**/
  UINT8                       Avx2VoltageScaleFactor;

/** Offset 0x08B1 - Avx512 Voltage Guardband Scaling Factor
  AVX512 Voltage Guardband Scale factor applied to AVX512 workloads. Range is 0-200
  in 1/100 units, where a value of 125 would apply a 1.25 scale factor.
**/
  UINT8                       Avx512VoltageScaleFactor;

/** Offset 0x08B2 - Lane Used of CSI port
   Lane Used of each CSI port
   1:x1, 2:x2, 3:x3, 4:x4, 8:x8
**/
  UINT8                       IpuLaneUsed[8];

/** Offset 0x08BA - Lane Used of CSI port
   Speed of each CSI port
  0:Sensor default, 1:<416Mbps, 2:<1.5Gbps, 3:<2Gbps, 4:<2.5Gbps, 5:<4Gbps, 6:>4Gbps
**/
  UINT8                       CsiSpeed[8];

/** Offset 0x08C2 - DPmem Support
  1: enable, 0: disable(Default), Enable/disable setting for Dynamic Persistent Memory support
  $EN_DIS
**/
  UINT8                       DpmemSupport;

/** Offset 0x08C3 - Core VF Point Offset Mode
  Selects Core Voltage & Frequency Point Offset between Legacy and Selection modes;
  <b>0: Legacy</b>; 1: Selection.
  0:Legacy, 1:Selection
**/
  UINT8                       CoreVfPointOffsetMode;

/** Offset 0x08C4 - Core VF Point Offset
  Array used to specifies the Offset Voltage applied to the each selected Core VF
  Point. This voltage is specified in millivolts.
**/
  UINT16                      CoreVfPointOffset[15];

/** Offset 0x08E2 - Core VF Point Offset Prefix
  Sets the CoreVfPointOffset value as positive or negative for corresponding core
  VF Point; <b>0: Positive </b>; 1: Negative.
  0:Positive, 1:Negative
**/
  UINT8                       CoreVfPointOffsetPrefix[15];

/** Offset 0x08F1 - Core VF Point Ratio
  Array for the each selected Core VF Point to display the ration.
**/
  UINT8                       CoreVfPointRatio[15];

/** Offset 0x0900 - Core VF Point Count
  Number of supported Core Voltage & Frequency Point Offset
**/
  UINT8                       CoreVfPointCount;

/** Offset 0x0901 - Enable CPU CrashLog GPRs dump
  Enable or Disable CPU CrashLog GPRs dump; <b>0: Disable</b>; 1: Enable; 2: Only
  disable Smm GPRs dump
  0:Disabled, 1:Enabled, 2:Only Smm GPRs Disabled
**/
  UINT8                       CrashLogGprs;

/** Offset 0x0902
**/
  UINT8                       UnusedUpdSpace23[2];

/** Offset 0x0904 - Bitmask of disable cores
  Core mask is a bitwise indication of which core should be disabled. <b>0x00=Default</b>;
  Bit 0 - core 0, bit 7 - core 7.
**/
  UINT32                      DisableCoreMask;

/** Offset 0x0908 - REFRESH_PANIC_WM
  <b>@deprecated</b> - Not used and has no effect, Please use RefreshWm
**/
  UINT8                       RefreshPanicWm;

/** Offset 0x0909 - REFRESH_HP_WM
  <b>@deprecated</b> - Not used and has no effect, Please use RefreshWm
**/
  UINT8                       RefreshHpWm;

/** Offset 0x090A - Support Unlimited ICCMAX
  Support Unlimited ICCMAX more than maximum value 255.75A; <b>0: Disabled</b>; 1: Enabled.
  $EN_DIS
**/
  UINT8                       UnlimitedIccMax;

/** Offset 0x090B - Per Core Max Ratio override
  Enable or disable Per Core PState OC supported by writing OCMB 0x1D to program new
  favored core ratio to each Core. <b>0: Disable</b>, 1: enable
  $EN_DIS
**/
  UINT8                       PerCoreRatioOverride;

/** Offset 0x090C - Per Core Current Max Ratio
  Array for the Per Core Max Ratio
**/
  UINT8                       PerCoreRatio[10];

/** Offset 0x0916 - Margin Limit Check
  Margin Limit Check. Choose level of margin check
  0:Disable, 1:L1, 2:L2, 3:Both
**/
  UINT8                       MarginLimitCheck;

/** Offset 0x0917
**/
  UINT8                       UnusedUpdSpace24;

/** Offset 0x0918 - Margin Limit L2
  % of L1 check for margin limit check
**/
  UINT16                      MarginLimitL2;

/** Offset 0x091A - Iotg Pll SscEn
  <b>@deprecated</b> - Not used and has no effect, Please use Pcie Ref Pll SSC
  $EN_DIS
**/
  UINT8                       IotgPllSscEn;

/** Offset 0x091B - GPIO Override
  Gpio Override Level - FSP will not configure any GPIOs and rely on GPIO setings
  before moved to FSP. Available configurations 0: Disable;1: Level 1 - skips GpioSetNativePadByFunction;Level
  2 - skips GpioSetNativePadByFunction and GpioSetPadMode
**/
  UINT8                       GpioOverride;

/** Offset 0x091C - Write0 enabling
  Enable/Disable Write0
  $EN_DIS
**/
  UINT8                       WRITE0;

/** Offset 0x091D
**/
  UINT8                       UnusedUpdSpace25[3];

/** Offset 0x0920
**/
  UINT32                      VccInVoltageOverride;

/** Offset 0x0924 - Dynamic Memory Timings Changes
  Dynamic Memory Timings Changes; <b>0: Disabled</b>; 1: Enabled.
  $EN_DIS
**/
  UINT8                       DynamicMemoryChange;

/** Offset 0x0925 - IbeccErrorInj
  In-Band ECC Error Injection NOTE: For Debug or Development purposes only! Disable
  this option for production systems.
  $EN_DIS
**/
  UINT8                       IbeccErrorInj;

/** Offset 0x0926 - Enable/Disable DMI GEN3 DmiGen3UsPresetEnable
  Enable/Disable DMI GEN3 DmiGen3UsPreset. Auto(0x0)(Default): DmiGen3UsPresetEnable,
  Manual(0x1): Enable DmiGen3UsPresetEnable
  $EN_DIS
**/
  UINT8                       DmiGen3UsPresetEnable;

/** Offset 0x0927 - DMI Gen3 Root port preset Rx values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-10, 7 is default
  for each lane
**/
  UINT8                       DmiGen3UsPortRxPreset[8];

/** Offset 0x092F - DMI Gen3 Root port preset Tx values per lane
  Used for programming DMI Gen3 preset values per lane. Range: 0-10, 1 is default
  for each lane
**/
  UINT8                       DmiGen3UsPortTxPreset[8];

/** Offset 0x0937 - BCLK Frequency Source
  Clock source of BCLK OC frequency, <b>0:CPU BCLK</b>, 1:PCH BCLK, 2:External CLK
  0:CPU BCLK, 1:PCH BCLK, 2:External CLK
**/
  UINT8                       BclkSource;

/** Offset 0x0938 - CPU BCLK OC Frequency
  CPU BCLK OC Frequency in 10KHz units increasing. Value 9800 (10KHz) = 98MHz <b>0
  - Auto</b>. Range is 8000-50000 (10KHz).
**/
  UINT32                      CpuBclkOcFrequency;

/** Offset 0x093C - Ring CCF Auto Gv Disable Down
  Ring CCF Auto Gv Disable Down, 0: Disabled, <b>1:Fused default</b>
  0:Disabled, 1:Fused default
**/
  UINT8                       RingCcfAutoGvDisable;

/** Offset 0x093D - SA/Uncore voltage mode
  SA/Uncore voltage mode; <b>0: Adaptive</b>; 1: Override.
  $EN_DIS
**/
  UINT8                       SaVoltageMode;

/** Offset 0x093E - SA/Uncore Voltage Override
  The SA/Uncore voltage override applicable when SA/Uncore voltage mode is in Override
  mode. Valid Range 0 to 2000
**/
  UINT16                      SaVoltageOverride;

/** Offset 0x0940 - SA/Uncore Extra Turbo voltage
  Extra Turbo voltage applicable when SA/Uncore voltage mode is in Adaptive mode.
  Valid Range 0 to 2000
**/
  UINT16                      SaExtraTurboVoltage;

/** Offset 0x0942 - DdrMemoryDown
  DDR Memory Down Support.
  $EN_DIS
**/
  UINT8                       DdrMemoryDown;

/** Offset 0x0943
**/
  UINT8                       UnusedUpdSpace26;

/** Offset 0x0944 - The VccIn Max Voltage Limit
  This will override maximum VCCIN voltage limit to the voltage value specified. <b>0
  - no override</b> Valid Range 0 to 3000mV
**/
  UINT16                      VccInMaxLimit;

/** Offset 0x0946 - VccIO Voltage Override
  This will override VccIO output voltage level to the voltage value specified. Valid
  Range 0 to 2000
**/
  UINT16                      VccIoVoltageOverride;

/** Offset 0x0948 - Boost VRef Voltage
  <b> Default: 0: 0.7V </b> 1: 1.0V to support the high frequencies needed for BCLK OC.
  0: 0.7V , 1:1.0V
**/
  UINT8                       BoostRefVoltage;

/** Offset 0x0949 - Pcie Ref Pll SSC
  Pcie Ref Pll SSC Percentatge. 0x0: 0.0%, 0x1: 0.1%, 0x2:0.2%, 0x3: 0.3%, 0x4: 0.4%,
  0x5: 0.5%, 0xFE: Disable, 0xFF: Auto
**/
  UINT8                       PcieRefPllSsc;

/** Offset 0x094A - Refresh Watermarks
  Refresh Watermark, High, Low
  1:Enable Refresh Watermark High (Default), 0:Enable Refresh Watermark Low
**/
  UINT8                       RefreshWm;

/** Offset 0x094B - Row Hammer Refresh Solution
  Type of Refresh Rate used to prevent Row Hammer. Default is 2x Refresh
  0:Hardware RHP, 1:1x Refresh, 2:2x Refresh, 3:4x Refresh, 4:NORMAL Refresh
**/
  UINT8                       RhRefreshSolution;

/** Offset 0x094C -  LCT Command eyewidth
   LCT Command eyewidth. 0: Auto, otherwise eyewidth , default is 96
**/
  UINT16                      LctCmdEyeWidth;

/** Offset 0x094E
**/
  UINT8                       UnusedUpdSpace27[3];

/** Offset 0x0951
**/
  UINT8                       ReservedFspmUpd2[7];
} FSP_M_CONFIG;

/** Fsp M UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSPM_ARCH_UPD               FspmArchUpd;

/** Offset 0x0040
**/
  FSP_M_CONFIG                FspmConfig;

/** Offset 0x0958
**/
  UINT8                       UnusedUpdSpace28[6];

/** Offset 0x095E
**/
  UINT16                      UpdTerminator;
} FSPM_UPD;

#pragma pack()

#endif
